/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.back.listeners;

import io.github.nucleuspowered.nucleus.api.module.jail.NucleusJailService;
import io.github.nucleuspowered.nucleus.modules.back.config.BackConfig;
import io.github.nucleuspowered.nucleus.modules.back.services.BackHandler;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.type.Exclude;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.World;

public class BackListeners
implements IReloadableService.Reloadable,
ListenerBase {
    private final BackHandler handler;
    private final IPermissionService permissionService;
    private BackConfig backConfig = new BackConfig();
    @Nullable
    private final NucleusJailService jailService = Sponge.getServiceManager().provide(NucleusJailService.class).orElse(null);

    @Inject
    public BackListeners(INucleusServiceCollection serviceCollection) {
        this.handler = serviceCollection.getServiceUnchecked(BackHandler.class);
        this.permissionService = serviceCollection.permissionService();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.backConfig = serviceCollection.moduleDataProvider().getModuleConfig(BackConfig.class);
    }

    @Listener
    @Exclude(value={MoveEntityEvent.Teleport.Portal.class})
    public void onTeleportPlayer(MoveEntityEvent.Teleport event, @Getter(value="getTargetEntity") Player pl) {
        if (this.backConfig.isOnTeleport() && this.check(event) && this.getLogBack(pl) && this.permissionService.hasPermission((Subject)pl, "nucleus.back.targets.teleport")) {
            this.handler.setLastLocation((User)pl, (Transform<World>)event.getFromTransform());
        }
    }

    @Listener
    public void onPortalPlayer(MoveEntityEvent.Teleport.Portal event, @Getter(value="getTargetEntity") Player pl) {
        if (this.backConfig.isOnPortal() && this.check((MoveEntityEvent.Teleport)event) && this.getLogBack(pl) && this.permissionService.hasPermission((Subject)pl, "nucleus.back.targets.portal")) {
            this.handler.setLastLocation((User)pl, (Transform<World>)event.getFromTransform());
        }
    }

    @Listener
    public void onDeathEvent(DestructEntityEvent.Death event) {
        Living e = event.getTargetEntity();
        if (!(e instanceof Player)) {
            return;
        }
        Player pl = (Player)e;
        if (this.backConfig.isOnDeath() && this.getLogBack(pl) && this.permissionService.hasPermission((Subject)pl, "nucleus.back.targets.death")) {
            this.handler.setLastLocation((User)pl, (Transform<World>)event.getTargetEntity().getTransform());
        }
    }

    private boolean check(MoveEntityEvent.Teleport event) {
        return !event.getFromTransform().equals((Object)event.getToTransform());
    }

    private boolean getLogBack(Player player) {
        return (this.jailService == null || !this.jailService.isPlayerJailed((User)player)) && this.handler.isLoggingLastLocation((User)player);
    }
}

