/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands.nucleus;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.messageprovider.repository.ConfigFileMessagesRepository;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import java.util.List;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

@Command(aliases={"update-messages"}, basePermission={"nucleus.nucleus.update-messages.base"}, commandDescriptionKey="nucleus.update-messages", async=true)
public class MessagesUpdateCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"y"}).buildWith(GenericArguments.none())};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        IMessageProviderService messageProviderService = context.getServiceCollection().messageProvider();
        boolean reload = messageProviderService.reloadMessageFile();
        if (!reload) {
            context.errorResult("command.nucleus.messageupdate.notfile", new Object[0]);
        }
        ConfigFileMessagesRepository messagesRepository = messageProviderService.getConfigFileMessageRepository();
        List<String> mismatched = messagesRepository.walkThroughForMismatched();
        context.sendMessage("command.nucleus.messageupdate.reloaded", new Object[0]);
        if (mismatched.isEmpty()) {
            return context.successResult();
        }
        if (context.hasAny("y")) {
            messagesRepository.fixMismatched(mismatched);
            context.sendMessage("command.nucleus.messageupdate.reset", new Object[0]);
        } else {
            context.sendMessage("command.nucleus.messageupdate.sometoupdate", String.valueOf(mismatched.size()));
            mismatched.forEach(x -> context.sendMessageText(Text.of((Object[])new Object[]{TextColors.YELLOW, x})));
            messageProviderService.getMessageFor(context.getCommandSource().getLocale(), "command.nucleus.messageupdate.confirm", "/nucleus update-messages -y").toBuilder().onClick((ClickAction)TextActions.runCommand((String)"/nucleus update-messages -y")).build();
        }
        return context.successResult();
    }
}

