/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands.nucleus.debug;

import io.github.nucleuspowered.nucleus.modules.core.commands.nucleus.DebugCommand;
import io.github.nucleuspowered.nucleus.modules.core.services.UniqueUserService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.channel.MessageReceiver;

@Command(aliases={"refreshuniquevisitors"}, basePermission={"nucleus.nucleus.debug.refreshuniquevisitors.base"}, commandDescriptionKey="nucleus.debug.refreshuniquevisitors", parentCommand=DebugCommand.class)
public class RefreshUniqueVisitors
implements ICommandExecutor<CommandSource> {
    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Supplier<CommandSource> scs;
        UniqueUserService uus = context.getServiceCollection().getServiceUnchecked(UniqueUserService.class);
        context.sendMessage("command.nucleus.debug.refreshuniquevisitors.started", uus.getUniqueUserCount());
        Optional<UUID> optionalUUID = context.getUniqueId();
        if (optionalUUID.isPresent()) {
            UUID uuid = optionalUUID.get();
            scs = () -> Sponge.getServer().getPlayer(uuid).map(x -> x).orElseGet(() -> ((Server)Sponge.getServer()).getConsole());
        } else {
            scs = () -> ((Server)Sponge.getServer()).getConsole();
        }
        uus.resetUniqueUserCount(l -> context.sendMessageTo((MessageReceiver)scs.get(), "command.nucleus.debug.refreshuniquevisitors.done", l));
        return context.successResult();
    }
}

