/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.listeners;

import com.google.common.collect.ImmutableList;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IChatMessageFormatterService;
import java.util.Collection;
import java.util.Optional;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;

public class ChatChannelListener
implements ListenerBase {
    private final IChatMessageFormatterService chatMessageFormatter;

    public ChatChannelListener(INucleusServiceCollection serviceCollection) {
        this.chatMessageFormatter = serviceCollection.chatMessageFormatter();
    }

    @Listener(order=Order.LATE)
    public void onChatMessageLast(MessageChannelEvent.Chat chat, @Root CommandSource source) {
        Optional<IChatMessageFormatterService.Channel> channelOptional = this.chatMessageFormatter.getNucleusChannel(Util.getUUID(source));
        if (channelOptional.map(IChatMessageFormatterService.Channel::willFormat).orElse(false).booleanValue()) {
            IChatMessageFormatterService.Channel channel = channelOptional.get();
            channel.formatMessageEvent(source, chat.getFormatter());
            chat.setChannel(chat.getChannel().map(x -> {
                MutableMessageChannel messageChannel = x.asMutable();
                for (MessageReceiver toSendTo : ImmutableList.copyOf((Collection)messageChannel.getMembers())) {
                    if (channel.receivers().contains(toSendTo)) continue;
                    messageChannel.removeMember(toSendTo);
                }
                return messageChannel;
            }).orElseGet(() -> MessageChannel.fixed(channel.receivers())));
        }
    }
}

