/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.experience.commands;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.entity.ExperienceHolderData;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Command(aliases={"exp", "experience", "xp"}, basePermission={"nucleus.exp.base"}, commandDescriptionKey="exp")
@EssentialsEquivalent(value={"exp", "xp"})
@NonnullByDefault
public class ExperienceCommand
implements ICommandExecutor<CommandSource> {
    static final String experienceKey = "experience";
    static final String levelKey = "level";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_PLAYER.get(serviceCollection)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player pl = context.getPlayerFromArgs();
        ExperienceHolderData ehd = (ExperienceHolderData)pl.get(ExperienceHolderData.class).get();
        int exp = (Integer)ehd.totalExperience().get();
        int lv = (Integer)ehd.level().get();
        context.getServiceCollection().messageProvider().sendMessageTo(context.getCommandSource(), "command.exp.info", pl.getName(), exp, lv);
        return context.successResult();
    }

    static ICommandResult tellUserAboutExperience(ICommandContext<? extends CommandSource> context, Player pl, boolean isSuccess) throws CommandException {
        if (!isSuccess) {
            return context.errorResult("command.exp.set.error", new Object[0]);
        }
        int exp = (Integer)pl.get(Keys.TOTAL_EXPERIENCE).get();
        int newLvl = (Integer)pl.get(Keys.EXPERIENCE_LEVEL).get();
        CommandSource src = context.getCommandSource();
        IMessageProviderService messageProviderService = context.getServiceCollection().messageProvider();
        if (!src.equals(pl)) {
            messageProviderService.sendMessageTo(src, "command.exp.set.new.other", pl.getName(), exp, newLvl);
        }
        messageProviderService.sendMessageTo((CommandSource)pl, "command.exp.set.new.self", String.valueOf(exp), String.valueOf(newLvl));
        return context.successResult();
    }

    static Optional<ICommandResult> checkGameMode(ICommandContext<? extends CommandSource> source, Player pl) throws CommandException {
        GameMode gm = pl.get(Keys.GAME_MODE).orElse(GameModes.SURVIVAL);
        if (gm == GameModes.CREATIVE || gm == GameModes.SPECTATOR) {
            return Optional.of(source.errorResult("command.exp.gamemode", pl.getName()));
        }
        return Optional.empty();
    }
}

