/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.inventory.commands;

import io.github.nucleuspowered.nucleus.modules.inventory.listeners.InvSeeListener;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.IfConditionElseArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"enderchest", "ec", "echest"}, basePermission={"nucleus.enderchest.base"}, commandDescriptionKey="enderchest", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.enderchest.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.enderchest.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.enderchest.exempt.cost")}, associatedPermissions={"nucleus.enderchest.others", "nucleus.enderchest.exempt.target", "nucleus.enderchest.exempt.modify", "nucleus.enderchest.modify", "nucleus.enderchest.offline"})
@EssentialsEquivalent(value={"enderchest", "echest", "endersee", "ec"})
public class EnderChestCommand
implements ICommandExecutor<Player> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.optional((CommandElement)serviceCollection.commandElementSupplier().createPermissionParameter(IfConditionElseArgument.permission(serviceCollection.permissionService(), "nucleus.enderchest.offline", NucleusParameters.ONE_USER_PLAYER_KEY.get(serviceCollection), NucleusParameters.ONE_PLAYER.get(serviceCollection)), "nucleus.enderchest.others", false))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        User target = context.getUserFromArgs("player");
        if (!context.is(target)) {
            if (context.testPermissionFor((Subject)target, "nucleus.enderchest.exempt.target")) {
                return context.errorResult("command.enderchest.targetexempt", target.getName());
            }
            Inventory ec = target.getEnderChestInventory();
            Container container = (Container)context.getCommandSourceAsPlayerUnchecked().openInventory(ec).orElseThrow(() -> context.createException("command.invsee.failed", new Object[0]));
            if (context.testPermissionFor((Subject)target, "nucleus.enderchest.exempt.modify") || !context.testPermission("nucleus.enderchest.modify")) {
                InvSeeListener.addEntry(context.getCommandSourceAsPlayerUnchecked().getUniqueId(), container);
            }
            return context.successResult();
        }
        return context.getCommandSourceAsPlayerUnchecked().openInventory(context.getCommandSourceAsPlayerUnchecked().getEnderChestInventory()).map(x -> context.successResult()).orElseGet(() -> context.errorResult("command.invsee.failed", new Object[0]));
    }
}

