/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.invulnerability.listeners;

import io.github.nucleuspowered.nucleus.modules.invulnerability.config.InvulnerabilityConfig;
import io.github.nucleuspowered.nucleus.modules.invulnerability.services.InvulnerabilityService;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import javax.inject.Inject;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.service.permission.Subject;

public class InvulnReloadableListener
implements ListenerBase.Conditional {
    private final IPermissionService permissionService;
    private final InvulnerabilityService service;

    @Inject
    public InvulnReloadableListener(INucleusServiceCollection serviceCollection) {
        this.permissionService = serviceCollection.permissionService();
        this.service = serviceCollection.getServiceUnchecked(InvulnerabilityService.class);
    }

    @Listener
    public void onPlayerJoin(ClientConnectionEvent.Join joinEvent, @Getter(value="getTargetEntity") Player player) {
        if (!this.permissionService.hasPermission((Subject)player, "nucleus.god.base")) {
            this.service.setInvulnerable((User)player, false);
        }
    }

    @Override
    public boolean shouldEnable(INucleusServiceCollection serviceCollection) {
        return serviceCollection.moduleDataProvider().getModuleConfig(InvulnerabilityConfig.class).isGodPermissionOnLogin();
    }
}

