/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.invulnerability.runnables;

import io.github.nucleuspowered.nucleus.modules.invulnerability.services.InvulnerabilityService;
import io.github.nucleuspowered.nucleus.scaffold.task.TaskBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.entity.FoodData;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class InvulnerabilityRunnable
implements TaskBase {
    private int defaultFoodLevel = 0;
    private double defaultSaturationLevel = 0.0;
    private double defaultExhaustionLevel = 0.0;
    private final InvulnerabilityService service;
    private final PluginContainer pluginContainer;

    @Inject
    public InvulnerabilityRunnable(INucleusServiceCollection serviceCollection) {
        this.service = serviceCollection.getServiceUnchecked(InvulnerabilityService.class);
        this.pluginContainer = serviceCollection.pluginContainer();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public Duration interval() {
        return Duration.of(5L, ChronoUnit.SECONDS);
    }

    @Override
    public void accept(Task task) {
        List toFeed;
        Collection cp = Sponge.getServer().getOnlinePlayers();
        if (cp.isEmpty()) {
            return;
        }
        if (this.defaultFoodLevel == 0) {
            FoodData def = ((Player)cp.iterator().next()).getFoodData();
            this.defaultFoodLevel = (Integer)def.foodLevel().getDefault();
            this.defaultSaturationLevel = (Double)def.saturation().getDefault();
            this.defaultExhaustionLevel = (Double)def.exhaustion().getDefault();
        }
        if (!(toFeed = cp.stream().filter(this.service::isInvulnerable).collect(Collectors.toList())).isEmpty()) {
            Sponge.getScheduler().createSyncExecutor((Object)this.pluginContainer).execute(() -> toFeed.forEach(p -> {
                p.offer(Keys.FOOD_LEVEL, (Object)this.defaultFoodLevel);
                p.offer(Keys.EXHAUSTION, (Object)this.defaultExhaustionLevel);
                p.offer(Keys.SATURATION, (Object)this.defaultSaturationLevel);
            }));
        }
    }
}

