/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"more"})
@NonnullByDefault
@Command(aliases={"more", "stack"}, basePermission={"nucleus.more.base"}, commandDescriptionKey="more", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.more.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.more.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.more.exempt.cost")})
public class MoreCommand
implements ICommandExecutor<Player> {
    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player player = context.getIfPlayer();
        if (player.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            ItemStack stack = (ItemStack)player.getItemInHand(HandTypes.MAIN_HAND).get();
            stack.setQuantity(stack.getMaxStackQuantity());
            player.setItemInHand(HandTypes.MAIN_HAND, stack);
            context.sendMessage("command.more.success", stack.getType().getName(), stack.getType().getMaxStackQuantity());
            return context.successResult();
        }
        return context.errorResult("command.more.none", new Object[0]);
    }
}

