/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.modules.item.config.ItemConfig;
import io.github.nucleuspowered.nucleus.modules.item.config.SkullConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.PositiveIntegerArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.ArrayList;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.SkullTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.entity.Hotbar;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.type.GridInventory;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@EssentialsEquivalent(value={"skull", "playerskull", "head"})
@Command(aliases={"skull"}, basePermission={"nucleus.skull.base"}, commandDescriptionKey="skull", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.skull.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.skull.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.skull.exempt.cost")}, associatedPermissions={"nucleus.skull.others"})
public class SkullCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private final String amountKey = "amount";
    private int amountLimit = Integer.MAX_VALUE;
    private boolean isUseMinecraftCommand = false;

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        SkullConfig config = serviceCollection.moduleDataProvider().getModuleConfig(ItemConfig.class).getSkullConfig();
        this.isUseMinecraftCommand = config.isUseMinecraftCommand();
        this.amountLimit = config.getSkullLimit();
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOtherUserPermissionElement(false, "nucleus.skull.others"), GenericArguments.optional((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)this.amountKey), serviceCollection))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        User user = context.getUserFromArgs();
        Player player = context.getIfPlayer();
        int amount = context.getOne(this.amountKey, Integer.class).orElse(1);
        if (amount > this.amountLimit && !context.isConsoleAndBypass() && !context.testPermission("nucleus.skull.exempt.limit")) {
            return context.errorResult("command.skull.limit", this.amountLimit);
        }
        if (this.isUseMinecraftCommand) {
            CommandResult result = Sponge.getCommandManager().process((CommandSource)Sponge.getServer().getConsole(), String.format("minecraft:give %s skull %d 3 {SkullOwner:%s}", player.getName(), amount, user.getName()));
            if (result.getSuccessCount().orElse(0) > 0) {
                context.sendMessage("command.skull.success.plural", String.valueOf(amount), user.getName());
                return context.successResult();
            }
            return context.errorResult("command.skull.error", user.getName());
        }
        int fullStacks = amount / 64;
        int partialStack = amount % 64;
        ItemStack skullStack = ItemStack.builder().itemType(ItemTypes.SKULL).quantity(64).build();
        if (skullStack.offer(Keys.SKULL_TYPE, (Object)SkullTypes.PLAYER).isSuccessful() && skullStack.offer(Keys.REPRESENTED_PLAYER, (Object)user.getProfile()).isSuccessful()) {
            ArrayList itemStackList = Lists.newArrayList();
            if (fullStacks > 0) {
                itemStackList.add(skullStack);
                for (int i = 2; i <= fullStacks; ++i) {
                    itemStackList.add(skullStack.copy());
                }
            }
            if (partialStack > 0) {
                ItemStack is = skullStack.copy();
                is.setQuantity(partialStack);
                itemStackList.add(is);
            }
            int accepted = 0;
            int failed = 0;
            Inventory inventoryToOfferTo = player.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(Hotbar.class), QueryOperationTypes.INVENTORY_TYPE.of(GridInventory.class)});
            for (ItemStack itemStack : itemStackList) {
                int stackSize = itemStack.getQuantity();
                InventoryTransactionResult itr = inventoryToOfferTo.offer(itemStack);
                int currentFail = itr.getRejectedItems().stream().mapToInt(ItemStackSnapshot::getQuantity).sum();
                failed += currentFail;
                accepted += stackSize - currentFail;
            }
            if (accepted > 0) {
                if (failed > 0) {
                    context.sendMessage("command.skull.semifull", failed);
                }
                if (accepted == 1) {
                    context.sendMessage("command.skull.success.single", user.getName());
                } else {
                    context.sendMessage("command.skull.success.plural", accepted, user.getName());
                }
                return context.successResult();
            }
            return context.errorResult("command.skull.full", user.getName());
        }
        return context.errorResult("command.skull.error", user.getName());
    }
}

