/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jump.commands;

import io.github.nucleuspowered.nucleus.api.teleport.data.NucleusTeleportHelperFilters;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportResult;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.api.world.teleport.TeleportHelperFilters;

@NonnullByDefault
@Command(aliases={"top", "tosurface", "totop"}, basePermission={"nucleus.top.base"}, commandDescriptionKey="top", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.top.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.top.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.top.exempt.cost")}, associatedPermissions={"nucleus.top.others"})
public class TopCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"f"}).buildWith(serviceCollection.commandElementSupplier().createOnlyOtherUserPermissionElement(true, "nucleus.top.others"))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player playerToTeleport = context.getPlayerFromArgs();
        Location location = playerToTeleport.getLocation();
        double x = location.getX();
        double z = location.getZ();
        Location start = new Location(location.getExtent(), x, (double)((World)location.getExtent()).getBlockMax().getY(), z);
        BlockRayHit end = (BlockRayHit)BlockRay.from((Location)start).stopFilter(BlockRay.onlyAirFilter()).to(playerToTeleport.getLocation().getPosition().sub(0.0f, 1.0f, 0.0f)).end().orElseThrow(() -> context.createException("command.top.nothingfound", new Object[0]));
        if (playerToTeleport.getLocation().getBlockPosition().equals((Object)end.getBlockPosition())) {
            if (!context.is(playerToTeleport)) {
                return context.errorResult("command.top.attop.other", context.getDisplayName(playerToTeleport.getUniqueId()));
            }
            return context.errorResult("command.top.attop.self", new Object[0]);
        }
        boolean isSafe = !context.hasAny("f");
        TeleportResult result = context.getServiceCollection().teleportService().teleportPlayer(playerToTeleport, (Location<World>)end.getLocation(), playerToTeleport.getRotation(), false, TeleportScanners.NO_SCAN.get(), isSafe ? TeleportHelperFilters.SURFACE_ONLY : NucleusTeleportHelperFilters.NO_CHECK.get(), new TeleportHelperFilter[0]);
        if (result.isSuccessful()) {
            if (!context.is(playerToTeleport)) {
                context.sendMessage("command.top.success.other", context.getDisplayName(playerToTeleport.getUniqueId()));
            }
            context.sendMessageTo((MessageReceiver)playerToTeleport, "command.top.success.self", new Object[0]);
            return context.successResult();
        }
        if (result == TeleportResult.FAIL_NO_LOCATION) {
            return context.errorResult("command.top.notsafe", new Object[0]);
        }
        return context.errorResult("command.top.cancelled", new Object[0]);
    }
}

