/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kick.commands;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@EssentialsEquivalent(value={"kickall"})
@Command(aliases={"kickall"}, basePermission={"nucleus.kickall.base"}, commandDescriptionKey="kickall", associatedPermissionLevelKeys={"nucleus.kickall.whitelist"})
public class KickAllCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().permissionFlag("nucleus.kickall.whitelist", new String[]{"w", "f"}).buildWith(NucleusParameters.OPTIONAL_REASON)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        String r = context.getOne("reason", String.class).orElseGet(() -> context.getMessageString("command.kick.defaultreason", new Object[0]));
        boolean f = context.getOne("w", Boolean.class).orElse(false);
        if (f) {
            Sponge.getServer().setHasWhitelist(true);
        }
        Sponge.getServer().getOnlinePlayers().stream().filter(context::is).collect(Collectors.toList()).forEach(x -> x.kick(TextSerializers.FORMATTING_CODE.deserialize(r)));
        ConsoleSource console = Sponge.getServer().getConsole();
        context.sendMessage("command.kickall.message", new Object[0]);
        context.sendMessageTo((MessageReceiver)console, "command.kickall.message", new Object[0]);
        context.sendMessage("command.reason", r);
        context.sendMessageTo((MessageReceiver)console, "command.reason", r);
        if (f) {
            context.sendMessage("command.kickall.whitelist", new Object[0]);
            context.sendMessageTo((MessageReceiver)console, "command.kickall.whitelist", new Object[0]);
        }
        return context.successResult();
    }
}

