/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.kit.KitRedeemResult;
import io.github.nucleuspowered.nucleus.api.module.kit.data.Kit;
import io.github.nucleuspowered.nucleus.modules.kit.config.KitConfig;
import io.github.nucleuspowered.nucleus.modules.kit.services.KitService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IEconomyServiceProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.time.Duration;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@NonnullByDefault
@Command(aliases={"kit"}, basePermission={"nucleus.kit.base"}, commandDescriptionKey="kit", modifiers={@CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.kit.exempt.warmup")}, associatedPermissions={"nucleus.kits", "nucleus.kit.exempt.onetime", "nucleus.kit.exempt.cooldown", "nucleus.kit.exempt.cost"})
@EssentialsEquivalent(value={"kit, kits"}, isExact=false, notes="'/kit' redeems, '/kits' lists.")
public class KitCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private boolean isDrop;
    private boolean mustGetAll;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.getServiceUnchecked(KitService.class).createKitElement(true)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        double cost;
        Kit kit = context.requireOne("kit", Kit.class);
        KitService kitService = context.getServiceCollection().getServiceUnchecked(KitService.class);
        Player player = context.getCommandSourceAsPlayerUnchecked();
        IEconomyServiceProvider econHelper = context.getServiceCollection().economyServiceProvider();
        double d = cost = econHelper.serviceExists() ? kit.getCost() : 0.0;
        if (context.testPermission("nucleus.kit.exempt.cost")) {
            cost = 0.0;
        }
        if (cost > 0.0 && !econHelper.hasBalance(player, cost)) {
            return context.errorResult("command.kit.notenough", kit.getName(), econHelper.getCurrencySymbol(cost));
        }
        KitRedeemResult redeemResult = kitService.redeemKit(kit, player, true, this.mustGetAll);
        if (redeemResult.isSuccess()) {
            if (!redeemResult.rejectedItems().isEmpty()) {
                if (this.isDrop) {
                    context.sendMessage("command.kit.itemsdropped", new Object[0]);
                    redeemResult.rejectedItems().forEach(x -> Util.dropItemOnFloorAtLocation(x, (Location<World>)player.getLocation()));
                } else {
                    context.sendMessage("command.kit.fullinventory", new Object[0]);
                }
            }
            if (kit.isDisplayMessageOnRedeem()) {
                context.sendMessage("command.kit.spawned", kit.getName());
            }
            if (cost > 0.0 && econHelper.serviceExists()) {
                econHelper.withdrawFromPlayer(player, cost);
            }
            return context.successResult();
        }
        switch (redeemResult.getStatus()) {
            case ALREADY_REDEEMED_ONE_TIME: {
                return context.errorResult("command.kit.onetime.alreadyredeemed", kit.getName());
            }
            case COOLDOWN_NOT_EXPIRED: {
                return context.errorResult("command.kit.cooldown", context.getTimeString(redeemResult.getCooldownDuration().orElse(Duration.ZERO)), kit.getName());
            }
            case PRE_EVENT_CANCELLED: {
                return redeemResult.getMessage().map(x -> context.errorResultLiteral(Text.of((Object[])new Object[]{x}))).orElseGet(() -> context.errorResult("command.kit.cancelledpre", kit.getName()));
            }
            case NO_SPACE: {
                return context.errorResult("command.kit.fullinventorynosave", kit.getName());
            }
        }
        return context.errorResult("command.kit.fail", kit.getName());
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        KitConfig kca = serviceCollection.moduleDataProvider().getModuleConfig(KitConfig.class);
        this.isDrop = kca.isDropKitIfFull();
        this.mustGetAll = kca.isMustGetAll();
    }
}

