/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.kit.data.Kit;
import io.github.nucleuspowered.nucleus.modules.kit.commands.KitCommand;
import io.github.nucleuspowered.nucleus.modules.kit.services.KitService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.property.InventoryTitle;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"edit", "ed"}, basePermission={"nucleus.kit.edit.base"}, commandDescriptionKey="kit.edit", parentCommand=KitCommand.class)
public class KitEditCommand
implements ICommandExecutor<Player> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.getServiceUnchecked(KitService.class).createKitElement(false)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Kit kitInfo;
        KitService service = context.getServiceCollection().getServiceUnchecked(KitService.class);
        if (service.isOpen((kitInfo = context.requireOne("kit", Kit.class)).getName())) {
            return context.errorResult("command.kit.edit.current", kitInfo.getName());
        }
        Inventory inventory = Util.getKitInventoryBuilder().property("inventorytitle", (InventoryProperty)InventoryTitle.of((Text)context.getMessage("command.kit.edit.title", kitInfo.getName()))).build((Object)context.getServiceCollection().pluginContainer());
        kitInfo.getStacks().stream().filter(x -> !x.getType().equals(ItemTypes.NONE)).forEach(x -> inventory.offer(x.createStack()));
        Optional openedInventory = context.getIfPlayer().openInventory(inventory);
        if (openedInventory.isPresent()) {
            service.addKitInventoryToListener((Tuple<Kit, Inventory>)Tuple.of((Object)kitInfo, (Object)inventory), (Container)openedInventory.get());
            return context.successResult();
        }
        return context.errorResult("command.kit.edit.cantopen", kitInfo.getName());
    }
}

