/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.message.commands;

import io.github.nucleuspowered.nucleus.modules.message.services.MessageHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"socialspy"})
@NonnullByDefault
@Command(aliases={"socialspy"}, basePermission={"nucleus.socialspy.base"}, commandDescriptionKey="socialspy", associatedPermissionLevelKeys={"nucleus.socialspy.level"}, associatedPermissions={"nucleus.socialspy.force"})
public class SocialSpyCommand
implements ICommandExecutor<Player> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player src = context.getCommandSource();
        MessageHandler handler = context.getServiceCollection().getServiceUnchecked(MessageHandler.class);
        if (handler.forcedSocialSpyState((User)src).asBoolean()) {
            return context.errorResult("command.socialspy.forced", new Object[0]);
        }
        boolean spy = context.getOne("true|false", Boolean.class).orElseGet(() -> !handler.isSocialSpy((User)src));
        if (handler.setSocialSpy((User)src, spy)) {
            context.sendMessage(spy ? "command.socialspy.on" : "command.socialspy.off", new Object[0]);
            return context.successResult();
        }
        return context.errorResult("command.socialspy.unable", new Object[0]);
    }
}

