/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.misc.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.util.DataScanner;
import io.github.nucleuspowered.nucleus.util.TypeTokens;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.CommandFlags;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;

@NonnullByDefault
@Command(aliases={"blockinfo"}, basePermission={"nucleus.blockinfo.base"}, commandDescriptionKey="blockinfo", associatedPermissions={"nucleus.blockinfo.extended"})
public class BlockInfoCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().setUnknownShortFlagBehavior(CommandFlags.UnknownFlagBehavior.IGNORE).permissionFlag("nucleus.blockinfo.extended", new String[]{"e", "-extended"}).buildWith(NucleusParameters.OPTIONAL_LOCATION)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Location loc = null;
        if (context.hasAny("location")) {
            loc = context.getOne("location", TypeTokens.LOCATION_WORLD).filter(x -> x.getBlockType() != BlockTypes.AIR).orElse(null);
        } else {
            if (!context.is(Player.class)) {
                return context.errorResult("command.blockinfo.player", new Object[0]);
            }
            BlockRay bl = BlockRay.from((Entity)context.getIfPlayer()).distanceLimit(10.0).stopFilter(BlockRay.continueAfterFilter((Predicate)BlockRay.onlyAirFilter(), (int)1)).build();
            Optional ob = bl.end();
            if (ob.isPresent() && ((BlockRayHit)ob.get()).getLocation().getBlockType() != BlockTypes.AIR) {
                BlockRayHit brh = (BlockRayHit)ob.get();
                loc = brh.getLocation();
            }
        }
        if (loc != null) {
            BlockState b = loc.getBlock();
            BlockType it = b.getType();
            ArrayList<Text> lt = new ArrayList<Text>();
            lt.add(context.getMessage("command.blockinfo.id", it.getId(), it.getTranslation().get()));
            lt.add(context.getMessage("command.iteminfo.extendedid", b.getId()));
            if (context.hasAny("e") || context.hasAny("extended")) {
                Collection cb;
                Collection cp = b.getApplicableProperties();
                if (!cp.isEmpty()) {
                    cp.forEach(x -> {
                        if (x.getValue() != null) {
                            DataScanner.getInstance(context.getServiceCollection().messageProvider()).getText((CommandSource)context.getCommandSourceAsPlayerUnchecked(), "command.blockinfo.property.item", x.getKey().toString(), x.getValue()).ifPresent(lt::add);
                        }
                    });
                }
                if (!(cb = b.getTraits()).isEmpty()) {
                    cb.forEach(x -> b.getTraitValue(x).flatMap(v -> DataScanner.getInstance(context.getServiceCollection().messageProvider()).getText((CommandSource)context.getCommandSourceAsPlayerUnchecked(), "command.blockinfo.traits.item", x.getName(), v)).ifPresent(lt::add));
                }
            }
            Util.getPaginationBuilder(context.getCommandSource()).contents(lt).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).title(context.getMessage("command.blockinfo.list.header", String.valueOf(loc.getBlockX()), String.valueOf(loc.getBlockY()), String.valueOf(loc.getBlockZ()))).sendTo((MessageReceiver)context.getCommandSource());
            return context.successResult();
        }
        return context.errorResult("command.blockinfo.none", new Object[0]);
    }
}

