/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.configurate.config.CommonPermissionLevelConfig;
import io.github.nucleuspowered.nucleus.modules.mute.config.MuteConfig;
import io.github.nucleuspowered.nucleus.modules.mute.data.MuteData;
import io.github.nucleuspowered.nucleus.modules.mute.services.MuteHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@EssentialsEquivalent(value={"mute", "silence"}, isExact=false, notes="Unmuting a player should be done via the /unmute command.")
@Command(aliases={"mute"}, basePermission={"nucleus.mute.base"}, commandDescriptionKey="mute", associatedPermissionLevelKeys={"nucleus.mute.level"}, associatedPermissions={"nucleus.mute.exempt.length", "nucleus.mute.exempt.target", "nucleus.mute.notify", "nucleus.mute.seemutedchat"})
public class MuteCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private long maxMute = Long.MAX_VALUE;
    private CommonPermissionLevelConfig levelConfig = new CommonPermissionLevelConfig();

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_USER.get(serviceCollection), NucleusParameters.OPTIONAL_WEAK_DURATION.get(serviceCollection), NucleusParameters.OPTIONAL_REASON};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        MuteHandler handler = context.getServiceCollection().getServiceUnchecked(MuteHandler.class);
        User user = context.requireOne("user", User.class);
        Optional<Long> time = context.getOne("duration", Long.class);
        Optional<MuteData> omd = handler.getPlayerMuteData(user);
        Optional<String> reas = context.getOne("reason", String.class);
        if (!context.isConsoleAndBypass() && context.testPermissionFor((Subject)user, "nucleus.mute.exempt.target")) {
            return context.errorResult("command.mute.exempt", user.getName());
        }
        if (this.levelConfig.isUseLevels() && !context.isPermissionLevelOkay((Subject)user, "nucleus.mute.level", "nucleus.mute.base", this.levelConfig.isCanAffectSameLevel())) {
            return context.errorResult("command.modifiers.level.insufficient", user.getName());
        }
        String rs = reas.orElseGet(() -> context.getMessageString("command.mute.defaultreason", new Object[0]));
        UUID ua = Util.CONSOLE_FAKE_UUID;
        if (context.is(Player.class)) {
            ua = context.getIfPlayer().getUniqueId();
        }
        if (this.maxMute > 0L && time.orElse(Long.MAX_VALUE) > this.maxMute && !context.testPermission("nucleus.mute.exempt.target")) {
            return context.errorResult("command.mute.length.toolong", context.getTimeString(this.maxMute));
        }
        MuteData data = time.isPresent() ? (!user.isOnline() ? new MuteData(ua, rs, Duration.ofSeconds(time.get())) : new MuteData(ua, rs, Instant.now().plus((long)time.get(), ChronoUnit.SECONDS))) : new MuteData(ua, rs);
        CommandSource src = context.getCommandSource();
        if (handler.mutePlayer(user, data)) {
            MutableMessageChannel mc = context.getServiceCollection().permissionService().permissionMessageChannel("nucleus.mute.notify").asMutable();
            mc.addMember((MessageReceiver)src);
            if (time.isPresent()) {
                this.timedMute(context, user, data, time.get(), (MessageChannel)mc);
            } else {
                this.permMute(context, user, data, (MessageChannel)mc);
            }
            return context.successResult();
        }
        return context.errorResult("command.mute.fail", user.getName());
    }

    private void timedMute(ICommandContext<? extends CommandSource> context, User user, MuteData data, long time, MessageChannel mc) {
        String ts = context.getTimeString(time);
        mc.send(context.getMessage("command.mute.success.time", user.getName(), context.getName(), ts));
        mc.send(context.getMessage("standard.reasoncoloured", data.getReason()));
        if (user.isOnline()) {
            context.sendMessageTo((MessageReceiver)user.getPlayer().get(), "mute.playernotify.time", ts);
            context.sendMessageTo((MessageReceiver)user.getPlayer().get(), "command.reason", data.getReason());
        }
    }

    private void permMute(ICommandContext<? extends CommandSource> context, User user, MuteData data, MessageChannel mc) {
        mc.send(context.getMessage("command.mute.success.norm", user.getName(), context.getName()));
        mc.send(context.getMessage("standard.reasoncoloured", data.getReason()));
        if (user.isOnline()) {
            context.sendMessageTo((MessageReceiver)user.getPlayer().get(), "mute.playernotify.standard", new Object[0]);
            context.sendMessageTo((MessageReceiver)user.getPlayer().get(), "command.reason", data.getReason());
        }
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        MuteConfig config = serviceCollection.moduleDataProvider().getModuleConfig(MuteConfig.class);
        this.maxMute = config.getMaximumMuteLength();
        this.levelConfig = config.getLevelConfig();
    }
}

