/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.commands;

import io.github.nucleuspowered.nucleus.configurate.config.CommonPermissionLevelConfig;
import io.github.nucleuspowered.nucleus.modules.mute.config.MuteConfig;
import io.github.nucleuspowered.nucleus.modules.mute.services.MuteHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.service.permission.Subject;

@Command(aliases={"unmute"}, basePermission={"nucleus.mute.unmute"}, commandDescriptionKey="unmute", associatedPermissionLevelKeys={"nucleus.mute.level"})
public class UnmuteCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private CommonPermissionLevelConfig levelConfig = new CommonPermissionLevelConfig();

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_USER.get(serviceCollection)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User user = context.requireOne("user", User.class);
        MuteHandler handler = context.getServiceCollection().getServiceUnchecked(MuteHandler.class);
        if (this.levelConfig.isUseLevels() && !context.isPermissionLevelOkay((Subject)user, "nucleus.mute.level", "nucleus.mute.base", this.levelConfig.isCanAffectSameLevel())) {
            return context.errorResult("command.modifiers.level.insufficient", user.getName());
        }
        if (!handler.isMuted(user)) {
            return context.errorResult("command.unmute.notmuted", user.getName());
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause((Object)context.getCommandSource());
            handler.unmutePlayer(user, frame.getCurrentCause(), false);
            context.sendMessage("command.unmute.success", user.getName(), context.getName());
            ICommandResult iCommandResult = context.successResult();
            return iCommandResult;
        }
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        MuteConfig config = serviceCollection.moduleDataProvider().getModuleConfig(MuteConfig.class);
        this.levelConfig = config.getLevelConfig();
    }
}

