/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.note.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.note.data.NoteData;
import io.github.nucleuspowered.nucleus.modules.note.services.NoteHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"checknotes", "notes"}, basePermission={"nucleus.note.base"}, commandDescriptionKey="checknotes", async=true)
public class CheckNotesCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_USER.get(serviceCollection)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User user;
        NoteHandler handler = context.getServiceCollection().getServiceUnchecked(NoteHandler.class);
        List<NoteData> notes = handler.getNotesInternal(user = context.requireOne("user", User.class));
        if (notes.isEmpty()) {
            context.sendMessage("command.checknotes.none", user.getName());
            return context.successResult();
        }
        List messages = notes.stream().sorted(Comparator.comparing(NoteData::getDate)).map(x -> this.createMessage((NoteData)x, user, context, handler)).collect(Collectors.toList());
        messages.add(0, context.getMessage("command.checknotes.info", new Object[0]));
        PaginationService paginationService = (PaginationService)Sponge.getGame().getServiceManager().provideUnchecked(PaginationService.class);
        paginationService.builder().title(Text.builder().color(TextColors.GOLD).append(new Text[]{Text.of((Object[])new Object[]{context.getMessage("command.checknotes.header", user.getName())})}).build()).padding(Text.builder().color(TextColors.YELLOW).append(new Text[]{Text.of((String)"=")}).build()).contents(messages).sendTo((MessageReceiver)context.getCommandSource());
        return context.successResult();
    }

    private Text createMessage(NoteData note, User user, ICommandContext<? extends CommandSource> context, NoteHandler handler) {
        String name;
        if (note.getNoterInternal().equals(Util.CONSOLE_FAKE_UUID)) {
            name = Sponge.getServer().getConsole().getName();
        } else {
            Optional ou = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(note.getNoterInternal());
            name = ou.map(User::getName).orElseGet(() -> context.getMessageString("standard.unknown", new Object[0]));
        }
        int id = handler.getNotesInternal(user).indexOf(note) + 1;
        Text.Builder actions = context.getMessage("command.checknotes.action", new Object[0]).toBuilder();
        actions.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, " > "})});
        actions.append(new Text[]{Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.RED, context.getMessage("standard.action.delete", new Object[0])})}).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.checknotes.hover.delete", new Object[0]))).onClick((ClickAction)TextActions.runCommand((String)("/removenote " + user.getName() + " " + id))).build()});
        actions.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, " - "})});
        actions.append(new Text[]{Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, context.getMessage("standard.action.return", new Object[0])})}).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.checknotes.hover.return", new Object[0]))).onClick((ClickAction)TextActions.runCommand((String)("/checknotes " + user.getName()))).build()});
        actions.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, " < "})});
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("MMM dd, yyyy").withZone(ZoneId.systemDefault());
        String date = dtf.format(note.getDate());
        Text nodeMessage = context.getServiceCollection().textStyleService().addUrls(note.getNote());
        LiteralText.Builder information = Text.builder((String)name).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.checknotes.hover.check", new Object[0]))).onClick((ClickAction)TextActions.executeCallback(commandSource -> {
            context.getMessage("command.checknotes.id", String.valueOf(id));
            context.getMessage("command.checknotes.date", date);
            context.getMessage("command.checknotes.noter", name);
            context.getMessage("command.checknotes.note", nodeMessage);
            commandSource.sendMessage(actions.build());
        }));
        Text.Builder message = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, information.build()})}).append(new Text[]{Text.of((String)": ")}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, note.getNote()})});
        return message.build();
    }
}

