/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.notification.command;

import io.github.nucleuspowered.nucleus.modules.notification.config.NotificationConfig;
import io.github.nucleuspowered.nucleus.modules.notification.config.TitleConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.texttemplatefactory.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Collection;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.title.Title;

public abstract class TitleBase
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private final String multiplePerm;
    private final String type;
    private final Text fadeIn = Text.of((String)"fade in");
    private final Text fadeOut = Text.of((String)"fade out");
    private final Text time = Text.of((String)"time");
    private TitleConfig titleConfig = new TitleConfig();

    protected TitleBase(String multiplePerm, String type) {
        this.multiplePerm = multiplePerm;
        this.type = type;
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().valueFlag(NucleusParameters.MANY_PLAYER.get(serviceCollection), new String[]{"p"}).valueFlag(GenericArguments.doubleNum((Text)this.fadeIn), new String[]{"i"}).valueFlag(GenericArguments.doubleNum((Text)this.fadeOut), new String[]{"o"}).valueFlag(GenericArguments.doubleNum((Text)this.time), new String[]{"t"}).buildWith(NucleusParameters.MESSAGE)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Collection<Player> targets = !context.hasAny("player") ? Sponge.getServer().getOnlinePlayers() : context.getAll("player", Player.class);
        if (targets.isEmpty()) {
            return context.errorResult("command.title.noonline", new Object[0]);
        }
        if (targets.size() > 1 && !context.testPermission(this.multiplePerm)) {
            return context.errorResult("command.title.multi.noperms", new Object[0]);
        }
        CommandSource sender = context.getCommandSourceUnchecked();
        String message = context.requireOne("message", String.class);
        NucleusTextTemplateImpl textTemplate = context.getServiceCollection().textTemplateFactory().createFromAmpersandString(message);
        Title.Builder builder = Title.builder().fadeIn(Integer.valueOf(this.toTicks(context, this.fadeIn, this.titleConfig::getFadeIn))).fadeOut(Integer.valueOf(this.toTicks(context, this.fadeOut, this.titleConfig::getFadeOut))).stay(Integer.valueOf(this.toTicks(context, this.time, this.titleConfig::getTime)));
        if (targets.size() > 1) {
            for (Player pl : targets) {
                pl.sendTitle(this.applyToBuilder(builder, textTemplate.getForCommandSource((CommandSource)pl, sender)).build());
            }
            context.sendMessage("command.title.player.success.multi", this.type, targets.size());
        } else {
            Player pl = targets.iterator().next();
            Text t = textTemplate.getForCommandSource((CommandSource)pl, sender);
            pl.sendTitle(this.applyToBuilder(builder, t).build());
            context.sendMessage("command.title.player.success.single", this.type, t, pl.getName());
        }
        return context.successResult();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.titleConfig = serviceCollection.moduleDataProvider().getModuleConfig(NotificationConfig.class).getTitleDefaults();
    }

    private int toTicks(ICommandContext<? extends CommandSource> source, Text key, Supplier<Double> supplier) {
        return (int)(Math.max(0.05, source.getOne(key.toPlainSingle(), Double.TYPE).orElseGet(supplier)) * 20.0);
    }

    protected abstract Title.Builder applyToBuilder(Title.Builder var1, Text var2);
}

