/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.playerinfo.commands;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableMap;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.core.CoreKeys;
import io.github.nucleuspowered.nucleus.modules.playerinfo.services.SeenHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerInformationService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerOnlineService;
import io.github.nucleuspowered.nucleus.util.TriFunction;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.storage.WorldProperties;

@EssentialsEquivalent(value={"seen"})
@NonnullByDefault
@Command(aliases={"seen", "seenplayer", "lookup"}, basePermission={"nucleus.seen.base"}, commandDescriptionKey="seen", async=true, associatedPermissions={"nucleus.seen.extended.uuid", "nucleus.seen.extended.ip", "nucleus.seen.extended.firstplayed", "nucleus.seen.extended.lastplayed", "nucleus.seen.extended.speed.walking", "nucleus.seen.extended.speed.flying", "nucleus.seen.extended.location", "nucleus.seen.extended.flying.canfly", "nucleus.seen.extended.flying.isflying", "nucleus.seen.extended.gamemode"})
public class SeenCommand
implements ICommandExecutor<CommandSource> {
    private static final NumberFormat NUMBER_FORMATTER = new DecimalFormat("0.00");
    private final ImmutableMap<String, TriFunction<ICommandContext<? extends CommandSource>, User, IUserDataObject, Text>> entries = ImmutableMap.builder().put((Object)"nucleus.seen.extended.uuid", this::getUUID).put((Object)"nucleus.seen.extended.ip", this::getIP).put((Object)"nucleus.seen.extended.firstplayed", this::getFirstPlayed).put((Object)"nucleus.seen.extended.lastplayed", this::getLastPlayed).put((Object)"nucleus.seen.extended.speed.walking", this::getWalkingSpeed).put((Object)"nucleus.seen.extended.speed.flying", this::getFlyingSpeed).put((Object)"nucleus.seen.extended.location", this::getLocation).put((Object)"nucleus.seen.extended.flying.canfly", this::getCanFly).put((Object)"nucleus.seen.extended.flying.isflying", this::getIsFlying).put((Object)"nucleus.seen.extended.gamemode", this::getGameMode).build();

    @Nullable
    private Text getUUID(ICommandContext<? extends CommandSource> context, User user, IUserDataObject userDataModule) {
        return context.getMessage("command.seen.uuid", user.getUniqueId());
    }

    @Nullable
    private Text getIP(ICommandContext<? extends CommandSource> context, User user, IUserDataObject userDataModule) {
        Tuple res = user.getPlayer().map(pl -> Tuple.of((Object)context.getMessage("command.seen.ipaddress", pl.getConnection().getAddress().getAddress().toString()), (Object)pl.getConnection().getAddress().getAddress().toString())).orElseGet(() -> userDataModule.get(CoreKeys.IP_ADDRESS).map(x -> Tuple.of((Object)context.getMessage("command.seen.lastipaddress", x), (Object)x)).orElse(null));
        if (res != null) {
            if (Sponge.getCommandManager().get("nucleus:getfromip").isPresent()) {
                return ((Text)res.getFirst()).toBuilder().onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.seen.ipclick", new Object[0]))).onClick((ClickAction)TextActions.runCommand((String)("/nucleus:getfromip " + ((String)res.getSecond()).replaceAll("^/", "")))).build();
            }
            return (Text)res.getFirst();
        }
        return null;
    }

    @Nullable
    private Text getFirstPlayed(ICommandContext<? extends CommandSource> context, User user, IUserDataObject userDataModule) {
        Optional<Instant> i = user.get(Keys.FIRST_DATE_PLAYED);
        if (!i.isPresent()) {
            i = userDataModule.get(CoreKeys.FIRST_JOIN);
        }
        return i.map(x -> context.getMessage("command.seen.firstplayed", DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(context.getCommandSourceUnchecked().getLocale()).withZone(ZoneId.systemDefault()).format((TemporalAccessor)x))).orElse(null);
    }

    @Nullable
    private Text getLastPlayed(ICommandContext<? extends CommandSource> context, User user, IUserDataObject userDataModule) {
        if (user.isOnline()) {
            return null;
        }
        return user.get(Keys.LAST_DATE_PLAYED).map(x -> context.getMessage("command.seen.lastplayed", DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(context.getCommandSourceUnchecked().getLocale()).withZone(ZoneId.systemDefault()).format((TemporalAccessor)x))).orElse(null);
    }

    @Nullable
    private Text getLocation(ICommandContext<? extends CommandSource> context, User user, IUserDataObject userDataModule) {
        if (user.isOnline()) {
            return this.getLocationString("command.seen.currentlocation", (Location<World>)((Player)user.getPlayer().get()).getLocation(), context);
        }
        Optional<Text> wp = user.getWorldUniqueId().flatMap(x -> Sponge.getServer().getWorldProperties(x));
        return wp.map(worldProperties -> this.getLocationString("command.seen.lastlocation", (WorldProperties)worldProperties, user.getPosition(), context)).orElseGet(() -> context.getMessage("standard.unknown", new Object[0]));
    }

    @Nullable
    private Text getWalkingSpeed(ICommandContext<? extends CommandSource> context, User user, IUserDataObject userDataModule) {
        return user.get(Keys.WALKING_SPEED).map(x -> context.getMessage("command.seen.speed.walk", NUMBER_FORMATTER.format(x * 20.0))).orElse(null);
    }

    @Nullable
    private Text getFlyingSpeed(ICommandContext<? extends CommandSource> context, User user, IUserDataObject userDataModule) {
        return user.get(Keys.FLYING_SPEED).map(x -> context.getMessage("command.seen.speed.fly", NUMBER_FORMATTER.format(x * 20.0))).orElse(null);
    }

    @Nullable
    private Text getCanFly(ICommandContext<? extends CommandSource> context, User user, IUserDataObject userDataModule) {
        return context.getMessage("command.seen.canfly", this.getYesNo(user.get(Keys.CAN_FLY).orElse(false), context));
    }

    @Nullable
    private Text getIsFlying(ICommandContext<? extends CommandSource> context, User user, IUserDataObject userDataModule) {
        return context.getMessage("command.seen.isflying", this.getYesNo(user.get(Keys.IS_FLYING).orElse(false), context));
    }

    @Nullable
    private Text getGameMode(ICommandContext<? extends CommandSource> context, User user, IUserDataObject userDataModule) {
        return user.get(Keys.GAME_MODE).map(x -> context.getMessage("command.seen.gamemode", x.getName())).orElse(null);
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{NucleusParameters.ONE_USER_UUID.get(serviceCollection), NucleusParameters.ONE_USER.get(serviceCollection)})};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User user = context.getOne("user uuid", User.class).orElseGet(() -> context.requireOne("user", User.class));
        user = user.getPlayer().map(x -> x).orElse(user);
        IUserDataObject userDataObject = (IUserDataObject)context.getServiceCollection().storageManager().getUserService().getOrNewOnThread(user.getUniqueId());
        ArrayList<Text> messages = new ArrayList<Text>();
        IPlayerOnlineService playerOnlineService = context.getServiceCollection().playerOnlineService();
        if (playerOnlineService.isOnline(context.getCommandSource(), user)) {
            messages.add(context.getMessage("command.seen.iscurrently.online", user.getName()));
            userDataObject.get(CoreKeys.LAST_LOGIN).ifPresent(x -> messages.add(context.getMessage("command.seen.loggedon", context.getTimeString(Duration.between(x, Instant.now())))));
        } else {
            messages.add(context.getMessage("command.seen.iscurrently.offline", user.getName()));
            playerOnlineService.lastSeen(context.getCommandSource(), user).ifPresent(x -> messages.add(context.getMessage("command.seen.loggedoff", context.getTimeString(Duration.between(Instant.now(), x)))));
        }
        messages.add(context.getMessage("command.seen.displayname", context.getDisplayName(user.getUniqueId())));
        messages.add(Util.SPACE);
        for (Map.Entry entry : this.entries.entrySet()) {
            Text m;
            if (!context.testPermission((String)entry.getKey()) || (m = (Text)((TriFunction)entry.getValue()).accept(context, user, userDataObject)) == null) continue;
            messages.add(m);
        }
        IPlayerInformationService playerInformationService = context.getServiceCollection().playerInformationService();
        for (IPlayerInformationService.Provider provider : playerInformationService.getProviders()) {
            provider.get(user, context.getCommandSource(), context.getServiceCollection()).ifPresent(messages::add);
        }
        messages.addAll(context.getServiceCollection().getServiceUnchecked(SeenHandler.class).getText(context.getCommandSource(), user));
        Util.getPaginationBuilder(context.getCommandSource()).contents(messages).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).title(context.getMessage("command.seen.title", user.getName())).sendTo((MessageReceiver)context.getCommandSource());
        return context.successResult();
    }

    private Text getLocationString(String key, Location<World> lw, ICommandContext<? extends CommandSource> source) {
        return this.getLocationString(key, ((World)lw.getExtent()).getProperties(), lw.getPosition(), source);
    }

    private Text getLocationString(String key, WorldProperties worldProperties, Vector3d position, ICommandContext<? extends CommandSource> context) {
        Text text = context.getMessage(key, context.getMessage("command.seen.locationtemplate", worldProperties.getWorldName(), position.toInt().toString()));
        if (Sponge.getCommandManager().get("nucleus:tppos").map(x -> x.getCallable().testPermission(context.getCommandSourceUnchecked())).orElse(false).booleanValue()) {
            Text.Builder building = text.toBuilder().onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.seen.teleportposition", new Object[0])));
            Sponge.getServer().getWorld(worldProperties.getUniqueId()).ifPresent(x -> building.onClick((ClickAction)TextActions.executeCallback(cs -> {
                if (cs instanceof Player) {
                    context.getServiceCollection().teleportService().setLocation((Player)cs, (Location<World>)new Location((Extent)x, position));
                }
            })));
            return building.build();
        }
        return text;
    }

    private String getYesNo(@Nullable Boolean bool, ICommandContext<? extends CommandSource> context) {
        if (bool == null) {
            bool = false;
        }
        return context.getMessageString("standard.yesno." + bool.toString().toLowerCase(), new Object[0]);
    }
}

