/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.teleport.commands;

import io.github.nucleuspowered.nucleus.modules.teleport.events.RequestEvent;
import io.github.nucleuspowered.nucleus.modules.teleport.services.PlayerTeleporterService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.NotifyIfAFK;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.ICooldownService;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.plugin.meta.util.NonnullByDefault;

@NonnullByDefault
@EssentialsEquivalent(value={"tpahere"})
@NotifyIfAFK(value={"player"})
@Command(aliases={"tpahere", "tpaskhere", "teleportaskhere"}, basePermission={"nucleus.teleport.tpahere.base"}, commandDescriptionKey="tpahere", modifiers={@CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.teleport.tpahere.exempt.warmup", onExecute=false, onCompletion=false), @CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.teleport.tpahere.exempt.cooldown"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.teleport.tpahere.exempt.cost")}, associatedPermissions={"nucleus.teleport.tptoggle.exempt", "nucleus.teleport.tpahere.force"})
public class TeleportAskHereCommand
implements ICommandExecutor<Player> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().permissionFlag("nucleus.teleport.tpahere.force", new String[]{"f"}).buildWith(NucleusParameters.ONE_PLAYER.get(serviceCollection))};
    }

    @Override
    public Optional<ICommandResult> preExecute(ICommandContext.Mutable<? extends Player> context) throws CommandException {
        boolean cont = context.getServiceCollection().getServiceUnchecked(PlayerTeleporterService.class).canTeleportTo((CommandSource)context.getIfPlayer(), (User)context.requireOne("player", Player.class));
        return cont ? Optional.empty() : Optional.of(context.failResult());
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player target = context.requireOne("player", Player.class);
        if (context.is(target)) {
            return context.errorResult("command.teleport.self", new Object[0]);
        }
        Player src = context.getCommandSource();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause((Object)src);
            RequestEvent.PlayerToCause event = new RequestEvent.PlayerToCause(frame.getCurrentCause(), target);
            if (Sponge.getEventManager().post((Event)event)) {
                ICommandResult iCommandResult = event.getCancelMessage().map(context::errorResultLiteral).orElseGet(() -> context.errorResult("command.tpa.eventfailed", new Object[0]));
                return iCommandResult;
            }
            ICooldownService cooldownService = context.getServiceCollection().cooldownService();
            Duration cooldownSeconds = Duration.ofSeconds(context.getCooldown());
            String key = context.getCommandKey();
            Consumer<Player> cooldownSetter = player -> cooldownService.setCooldown(key, (Identifiable)player, cooldownSeconds);
            context.getServiceCollection().getServiceUnchecked(PlayerTeleporterService.class).requestTeleport(src, target, context.getCost(), context.getWarmup(), target, src, context.getOne("f", Boolean.class).orElse(false) == false, false, false, cooldownSetter, "command.tpahere.question");
            ICommandResult iCommandResult = context.successResult();
            return iCommandResult;
        }
    }
}

