/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.commands;

import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.api.module.warp.data.Warp;
import io.github.nucleuspowered.nucleus.api.module.warp.data.WarpCategory;
import io.github.nucleuspowered.nucleus.modules.warp.commands.WarpCommand;
import io.github.nucleuspowered.nucleus.modules.warp.services.WarpService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"setcategory"}, basePermission={"nucleus.warp.setcategory.base"}, commandDescriptionKey="warp.setcategory", async=true, parentCommand=WarpCommand.class)
public class SetCategoryCommand
implements ICommandExecutor<CommandSource> {
    private static final TypeToken<Tuple<String, Boolean>> TUPLE_TYPE_TOKEN = new TypeToken<Tuple<String, Boolean>>(){};

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"r", "-remove", "-delete"}).flag(new String[]{"n", "-new"}).buildWith(GenericArguments.seq((CommandElement[])new CommandElement[]{serviceCollection.getServiceUnchecked(WarpService.class).warpElement(false), GenericArguments.optional((CommandElement)new SetCategoryWarpCategoryArgument(serviceCollection.getServiceUnchecked(WarpService.class)))}))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        String warpName = context.requireOne("warp", Warp.class).getName();
        WarpService handler = context.getServiceCollection().getServiceUnchecked(WarpService.class);
        if (context.hasAny("r")) {
            if (handler.setWarpCategory(warpName, null)) {
                context.sendMessage("command.warp.category.removed", warpName);
                return context.successResult();
            }
            return context.errorResult("command.warp.category.noremove", warpName);
        }
        Optional<Tuple<String, Boolean>> categoryOp = context.getOne("warp category", TUPLE_TYPE_TOKEN);
        if (!categoryOp.isPresent()) {
            return context.errorResult("command.warp.category.required", new Object[0]);
        }
        Tuple<String, Boolean> category = categoryOp.get();
        if (!context.hasAny("n") && !((Boolean)category.getSecond()).booleanValue()) {
            context.sendMessageText(context.getMessage("command.warp.category.requirenew", category.getFirst()).toBuilder().onClick((ClickAction)TextActions.runCommand((String)("/warp setcategory -n " + warpName + " " + (String)category.getFirst()))).build());
            return context.failResult();
        }
        if (handler.setWarpCategory(warpName, (String)category.getFirst())) {
            context.sendMessage("command.warp.category.added", category.getFirst(), warpName);
            return context.successResult();
        }
        return context.errorResult("command.warp.category.couldnotadd", Text.of((String)((String)category.getFirst())), Text.of((String)warpName));
    }

    private static class SetCategoryWarpCategoryArgument
    extends CommandElement {
        private final WarpService service;

        SetCategoryWarpCategoryArgument(WarpService service) {
            super((Text)Text.of((String)"warp category"));
            this.service = service;
        }

        @Nullable
        protected Object parseValue(@Nonnull CommandSource source, @Nonnull CommandArgs args) throws ArgumentParseException {
            String arg = args.next();
            return Tuple.of((Object)arg, (Object)this.service.getWarpsWithCategories().keySet().stream().filter(Objects::nonNull).anyMatch(x -> x.getId().equals(arg)));
        }

        @Nonnull
        public List<String> complete(@Nonnull CommandSource src, @Nonnull CommandArgs args, @Nonnull CommandContext context) {
            return this.service.getWarpsWithCategories().keySet().stream().filter(Objects::nonNull).map(WarpCategory::getId).collect(Collectors.toList());
        }
    }
}

