/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.commands;

import io.github.nucleuspowered.nucleus.api.module.warp.data.Warp;
import io.github.nucleuspowered.nucleus.modules.warp.commands.WarpCommand;
import io.github.nucleuspowered.nucleus.modules.warp.event.CreateWarpEvent;
import io.github.nucleuspowered.nucleus.modules.warp.event.DeleteWarpEvent;
import io.github.nucleuspowered.nucleus.modules.warp.services.WarpService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.Optional;
import java.util.regex.Pattern;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@EssentialsEquivalent(value={"setwarp", "createwarp"})
@NonnullByDefault
@Command(aliases={"set", "#setwarp", "#warpset"}, parentCommand=WarpCommand.class, basePermission={"nucleus.warp.set.base"}, commandDescriptionKey="warp.set", modifiers={@CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.warp.set.exempt.warmup"), @CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.warp.set.exempt.cooldown"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.warp.set.exempt.cost")})
public class SetWarpCommand
implements ICommandExecutor<Player> {
    private final Pattern warpRegex = Pattern.compile("^[A-Za-z][A-Za-z0-9]{0,25}$");
    private final String overwriteKey = "overwrite";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().valueFlag((CommandElement)serviceCollection.commandElementSupplier().createPermissionParameter(GenericArguments.markTrue((Text)Text.of((String)this.overwriteKey)), "nucleus.warp.delete.base", false), new String[]{"o"}).buildWith(GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)"warp"))))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        String warp = context.requireOne("warp", String.class);
        if (!this.warpRegex.matcher(warp).matches()) {
            return context.errorResult("command.warps.invalidname", new Object[0]);
        }
        WarpService warpService = context.getServiceCollection().getServiceUnchecked(WarpService.class);
        Optional<Warp> exists = warpService.getWarp(warp);
        if (exists.isPresent()) {
            if (!context.hasAny(this.overwriteKey)) {
                return context.errorResult("command.warps.nooverwrite", new Object[0]);
            }
            DeleteWarpEvent event = new DeleteWarpEvent(context.getCause(), exists.get());
            if (Sponge.getEventManager().post((Event)event)) {
                return event.getCancelMessage().map(context::errorResultLiteral).orElseGet(() -> context.errorResult("nucleus.eventcancelled", new Object[0]));
            }
            String toRemove = exists.get().getName();
            if (warpService.removeWarp(toRemove)) {
                context.sendMessage("command.warps.del", toRemove);
            } else {
                return context.errorResult("command.warps.delerror", new Object[0]);
            }
        }
        Player src = context.getIfPlayer();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause((Object)src);
            CreateWarpEvent event = new CreateWarpEvent(frame.getCurrentCause(), warp, (Location<World>)src.getLocation());
            if (Sponge.getEventManager().post((Event)event)) {
                ICommandResult iCommandResult = event.getCancelMessage().map(context::errorResultLiteral).orElseGet(() -> context.errorResult("nucleus.eventcancelled", new Object[0]));
                return iCommandResult;
            }
            if (warpService.setWarp(warp, (Location<World>)src.getLocation(), src.getRotation())) {
                context.sendMessage("command.warps.set", warp);
                ICommandResult iCommandResult = context.successResult();
                return iCommandResult;
            }
            ICommandResult iCommandResult = context.errorResult("command.warps.seterror", new Object[0]);
            return iCommandResult;
        }
    }
}

