/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.util.Tuples;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@Command(aliases={"delete", "del"}, basePermission={"nucleus.world.delete.base"}, commandDescriptionKey="world.delete", parentCommand=WorldCommand.class)
public class DeleteWorldCommand
implements ICommandExecutor<CommandSource> {
    @Nullable
    private Tuples.Tri<Instant, UUID, WorldProperties> confirm = null;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.WORLD_PROPERTIES_ALL.get(serviceCollection)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        WorldProperties properties = context.requireOne("world", WorldProperties.class);
        if (this.confirm != null && this.confirm.getFirst().isAfter(Instant.now()) && this.confirm.getSecond().equals(context.getUniqueId().orElse(Util.CONSOLE_FAKE_UUID)) && this.confirm.getThird().getUniqueId().equals(properties.getUniqueId())) {
            try {
                ICommandResult iCommandResult = this.completeDeletion(context, properties);
                return iCommandResult;
            }
            finally {
                this.confirm = null;
            }
        }
        this.confirm = null;
        if (Sponge.getServer().getWorld(properties.getUniqueId()).isPresent()) {
            return context.errorResult("command.world.delete.loaded", properties.getWorldName());
        }
        this.confirm = Tuples.of(Instant.now().plus(30L, ChronoUnit.SECONDS), context.getUniqueId().orElse(Util.CONSOLE_FAKE_UUID), properties);
        context.sendMessage("command.world.delete.warning1", properties.getWorldName());
        context.sendMessage("command.world.delete.warning3", properties.getWorldName());
        return context.successResult();
    }

    private ICommandResult completeDeletion(ICommandContext<? extends CommandSource> context, WorldProperties properties) throws CommandException {
        Supplier<Optional> source;
        Preconditions.checkNotNull(this.confirm);
        String worldName = this.confirm.getThird().getWorldName();
        if (Sponge.getServer().getWorld(properties.getUniqueId()).isPresent()) {
            return context.errorResult("command.world.delete.loaded", this.confirm.getThird());
        }
        ConsoleSource consoleSource = Sponge.getServer().getConsole();
        context.sendMessage("command.world.delete.confirmed", worldName);
        if (!context.is((CommandSource)consoleSource)) {
            context.sendMessageTo((MessageReceiver)consoleSource, "command.world.delete.confirmed", worldName);
        }
        CompletableFuture completableFuture = Sponge.getServer().deleteWorld(properties);
        if (context.is(Player.class)) {
            UUID uuid = context.getIfPlayer().getUniqueId();
            source = () -> Sponge.getServer().getPlayer(uuid);
        } else {
            source = Optional::empty;
        }
        Task.builder().async().execute(task -> {
            boolean result;
            try {
                result = (Boolean)completableFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                result = false;
                e.printStackTrace();
            }
            if (!result) {
                ((Optional)source.get()).ifPresent(x -> context.sendMessageTo((MessageReceiver)x, "command.world.delete.complete.error", worldName));
                context.sendMessageTo((MessageReceiver)consoleSource, "command.world.delete.complete.error", worldName);
            } else {
                ((Optional)source.get()).ifPresent(x -> context.sendMessageTo((MessageReceiver)x, "command.world.delete.complete.success", worldName));
                context.sendMessageTo((MessageReceiver)consoleSource, "command.world.delete.complete.success", worldName);
            }
        }).submit((Object)context.getServiceCollection().pluginContainer());
        return context.successResult();
    }
}

