/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.world.commands.CreateWorldCommand;
import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@Command(aliases={"list", "ls", "#worlds"}, basePermission={"nucleus.world.list.base"}, commandDescriptionKey="world.list", parentCommand=WorldCommand.class, associatedPermissions={"nucleus.world.list.seed"})
public class ListWorldCommand
implements ICommandExecutor<CommandSource> {
    private static final Text SPACE = Text.of((String)" ");

    static void getWorldInfo(ICommandContext<? extends CommandSource> context, List<Text> listContent, WorldProperties x, boolean canSeeSeeds) {
        if (!listContent.isEmpty()) {
            listContent.add(SPACE);
        }
        listContent.add(context.getMessage("command.world.list.worlditem", x.getWorldName()));
        x.getAdditionalProperties().getInt(DataQuery.of((String[])new String[]{"SpongeData", "dimensionId"})).ifPresent(i -> listContent.add(context.getMessage("command.world.list.dimensionid", String.valueOf(i))));
        Vector3i spawnPosition = x.getSpawnPosition();
        listContent.add(context.getMessage("command.world.list.spawnpoint", String.valueOf(spawnPosition.getX()), String.valueOf(spawnPosition.getY()), String.valueOf(spawnPosition.getZ())));
        listContent.add(context.getMessage("command.world.list.uuid", x.getUniqueId().toString()));
        if (x.isEnabled()) {
            boolean worldLoaded = Sponge.getServer().getWorld(x.getUniqueId()).isPresent();
            Text loadedText = Text.of((Object[])new Object[]{worldLoaded ? TextColors.GREEN : TextColors.RED, context.getMessageString(worldLoaded ? "standard.true" : "standard.false", new Object[0])});
            listContent.add(context.getMessage("command.world.list.enabled", loadedText));
        } else {
            listContent.add(context.getMessage("command.world.list.disabled", new Object[0]));
        }
        if (canSeeSeeds) {
            listContent.add(context.getMessage("command.world.list.seed", String.valueOf(x.getSeed())));
        }
        listContent.add(context.getMessage("command.world.list.params", x.getDimensionType().getName(), x.getGeneratorType().getName(), CreateWorldCommand.modifierString(context, x.getGeneratorModifiers()), x.getGameMode().getName(), x.getDifficulty().getName()));
        listContent.add(context.getMessage("command.world.list.params2", String.valueOf(x.isHardcore()), String.valueOf(x.loadOnStartup()), String.valueOf(x.isPVPEnabled()), String.valueOf(x.doesKeepSpawnLoaded())));
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Collection cwp = Sponge.getServer().getAllWorldProperties();
        ArrayList listContent = Lists.newArrayList();
        boolean canSeeSeeds = context.testPermission("nucleus.world.list.seed");
        cwp.stream().sorted(Comparator.comparing(WorldProperties::getWorldName)).forEach(x -> ListWorldCommand.getWorldInfo(context, listContent, x, canSeeSeeds));
        Util.getPaginationBuilder(context.getCommandSourceUnchecked()).contents((Iterable)listContent).title(context.getMessage("command.world.list.title", new Object[0])).sendTo((MessageReceiver)context.getCommandSourceUnchecked());
        return context.successResult();
    }
}

