/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import io.github.nucleuspowered.nucleus.modules.world.commands.DisableWorldCommand;
import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.NucleusWorldPropertiesArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.CommandFlags;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@Command(aliases={"unload"}, basePermission={"nucleus.world.unload.base"}, commandDescriptionKey="world.unload", parentCommand=WorldCommand.class)
public class UnloadWorldCommand
implements ICommandExecutor<CommandSource> {
    private final String transferWorldKey = "transferWorld";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().permissionFlag("nucleus.world.disable.base", new String[]{"d", "-disable"}).valueFlag((CommandElement)new NucleusWorldPropertiesArgument((Text)Text.of((String)this.transferWorldKey), NucleusWorldPropertiesArgument.Type.ENABLED_ONLY, serviceCollection), new String[]{"t", "-transfer"}).setUnknownShortFlagBehavior(CommandFlags.UnknownFlagBehavior.IGNORE).buildWith(NucleusParameters.WORLD_PROPERTIES_ENABLED_ONLY.get(serviceCollection))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        WorldProperties worldProperties = context.requireOne("world", WorldProperties.class);
        Optional<WorldProperties> transferWorld = context.getOne(this.transferWorldKey, WorldProperties.class);
        boolean disable = context.hasAny("d");
        Optional worldOptional = Sponge.getServer().getWorld(worldProperties.getUniqueId());
        if (!worldOptional.isPresent()) {
            if (disable) {
                UnloadWorldCommand.disable(worldProperties, context, false);
            }
            return context.errorResult("command.world.unload.alreadyunloaded", worldProperties.getWorldName());
        }
        World world = (World)worldOptional.get();
        List<Player> playerCollection = Sponge.getServer().getOnlinePlayers().stream().filter(x -> x.getWorld().equals(world)).collect(Collectors.toList());
        if (transferWorld.isPresent() && transferWorld.get().isEnabled()) {
            playerCollection.forEach(x -> x.transferToWorld(((WorldProperties)transferWorld.get()).getUniqueId(), ((WorldProperties)transferWorld.get()).getSpawnPosition().toDouble()));
        }
        return UnloadWorldCommand.unloadWorld(context, world, disable);
    }

    private static ICommandResult disable(WorldProperties worldProperties, ICommandContext<? extends CommandSource> context, boolean messageOnError) {
        if (worldProperties.isEnabled()) {
            return DisableWorldCommand.disableWorld(context, worldProperties);
        }
        if (messageOnError) {
            return context.errorResult("command.world.disable.alreadydisabled", worldProperties.getWorldName());
        }
        return context.successResult();
    }

    private static ICommandResult unloadWorld(ICommandContext<? extends CommandSource> context, World world, boolean disable) {
        WorldProperties worldProperties = world.getProperties();
        context.sendMessage("command.world.unload.start", worldProperties.getWorldName());
        boolean unloaded = Sponge.getServer().unloadWorld(world);
        if (unloaded) {
            context.sendMessage("command.world.unload.success", worldProperties.getWorldName());
            if (disable) {
                return UnloadWorldCommand.disable(worldProperties, context, true);
            }
            return context.successResult();
        }
        return context.errorResult("command.world.unload.failed", worldProperties.getWorldName());
    }
}

