/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.listeners;

import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.modules.world.WorldPermissions;
import io.github.nucleuspowered.nucleus.modules.world.config.WorldConfig;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.api.world.teleport.TeleportHelperFilters;

public class WorldListener
implements ListenerBase.Conditional {
    private final Set<UUID> messageSent = Sets.newHashSet();
    private final INucleusServiceCollection serviceCollection;

    @Inject
    public WorldListener(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
    }

    @Listener
    public void onPlayerTeleport(MoveEntityEvent.Teleport event, @Getter(value="getTargetEntity") Player player) {
        World target = (World)event.getToTransform().getExtent();
        if (player.getWorld().equals(target)) {
            return;
        }
        IPermissionService permissionService = this.serviceCollection.permissionService();
        if (!permissionService.isConsoleOverride((Subject)event.getCause().first(CommandSource.class).orElse(player)) && !this.serviceCollection.permissionService().hasPermission((Subject)player, WorldPermissions.getWorldAccessPermission(target.getName()))) {
            event.setCancelled(true);
            if (!this.messageSent.contains(player.getUniqueId())) {
                this.serviceCollection.messageProvider().sendMessageTo((CommandSource)player, "world.access.denied", target.getName());
            }
            if (event instanceof MoveEntityEvent.Teleport.Portal) {
                this.messageSent.add(player.getUniqueId());
                Sponge.getScheduler().createTaskBuilder().delayTicks(1L).execute(this.relocate(player)).submit((Object)this.serviceCollection.pluginContainer());
            }
        }
    }

    @Override
    public boolean shouldEnable(INucleusServiceCollection serviceCollection) {
        return this.serviceCollection.moduleDataProvider().getModuleConfig(WorldConfig.class).isSeparatePermissions();
    }

    private Consumer<Task> relocate(Player player) {
        return task -> {
            Optional location = Sponge.getTeleportHelper().getSafeLocationWithBlacklist(player.getLocation(), 5, 5, 5, new TeleportHelperFilter[]{TeleportHelperFilters.NO_PORTAL});
            if (location.isPresent()) {
                player.setLocation((Location)location.get());
            } else {
                player.setLocationSafely(player.getWorld().getSpawnLocation());
            }
            this.messageSent.remove(player.getUniqueId());
        };
    }
}

