/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command;

import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.modifier.ICommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.world.storage.WorldProperties;

public interface ICommandContext<C extends CommandSource> {
    public Cause getCause();

    public String getCommandKey();

    public C getCommandSource() throws CommandException;

    public C getCommandSourceUnchecked();

    public Optional<UUID> getUniqueId();

    public int getCooldown();

    public void setCooldown(int var1);

    public double getCost();

    public void setCost(double var1);

    public int getWarmup();

    public void setWarmup(int var1);

    public Player getPlayerFromArgs(String var1, String var2) throws CommandException;

    default public Player getPlayerFromArgs() throws CommandException {
        return this.getPlayerFromArgs("player", "command.playeronly");
    }

    public Player getCommandSourceAsPlayerUnchecked();

    default public User getUserFromArgs() throws CommandException {
        return this.getUserFromArgs("user", "command.playeronly");
    }

    default public User getUserFromArgs(String key) throws CommandException {
        return this.getUserFromArgs(key, "command.playeronly");
    }

    public User getUserFromArgs(String var1, String var2) throws CommandException;

    public boolean hasAny(String var1);

    public <T> Optional<T> getOne(String var1, Class<T> var2);

    public <T> Optional<T> getOne(String var1, TypeToken<T> var2);

    public <T> Collection<T> getAll(String var1, Class<T> var2);

    public <T> Collection<T> getAll(String var1, TypeToken<T> var2);

    public <T> @NonNull T requireOne(String var1, Class<T> var2);

    public <T> @NonNull T requireOne(String var1, TypeToken<T> var2);

    public INucleusServiceCollection getServiceCollection();

    public ICommandResult successResult();

    public ICommandResult failResult();

    public ICommandResult errorResultLiteral(Text var1);

    public ICommandResult errorResult(String var1, Object ... var2);

    public ICommandResult getResultFromBoolean(boolean var1);

    public CommandException createException(Throwable var1, String var2, Object ... var3);

    public CommandException createException(String var1, Object ... var2);

    default public @NonNull Player getIfPlayer() throws CommandException {
        return this.getIfPlayer("command.playeronly");
    }

    public @NonNull Player getIfPlayer(String var1) throws CommandException;

    public Map<CommandModifier, ICommandModifier> modifiers();

    public Collection<Consumer<ICommandContext<C>>> failActions();

    public boolean testPermission(String var1);

    public boolean testPermissionFor(Subject var1, String var2);

    public String getMessageString(String var1, Object ... var2);

    public String getMessageStringFor(CommandSource var1, String var2, Object ... var3);

    public Text getMessage(String var1, Object ... var2);

    public Text getMessageFor(CommandSource var1, String var2, Object ... var3);

    default public String getTimeString(Duration duration) {
        return this.getTimeString(duration.getSeconds());
    }

    public String getTimeString(long var1);

    public void sendMessage(String var1, Object ... var2);

    public void sendMessageText(Text var1);

    public void sendMessageTo(MessageReceiver var1, String var2, Object ... var3);

    default public boolean is(Player other) {
        return this.is((CommandSource)other.getCommandSource().get());
    }

    public boolean is(CommandSource var1);

    public boolean is(Class<?> var1);

    public boolean is(User var1);

    default public boolean isNot(User x) {
        return !this.is(x);
    }

    public boolean isUser();

    public boolean isConsoleAndBypass();

    public Optional<WorldProperties> getWorldPropertiesOrFromSelf(String var1);

    public String getName();

    public Text getDisplayName();

    public Text getDisplayName(UUID var1);

    default public String getTimeToNowString(Instant endTime) {
        return this.getTimeString(Duration.between(Instant.now(), endTime).abs());
    }

    default public OptionalInt getLevel(String key) {
        return this.getLevelFor((Subject)this.getCommandSourceUnchecked(), key);
    }

    public OptionalInt getLevelFor(Subject var1, String var2);

    default public int getLevel(String key, String permissionIfNoLevel) {
        return this.getLevelFor((Subject)this.getCommandSourceUnchecked(), key, permissionIfNoLevel);
    }

    default public int getLevelFor(Subject subject, String key, String permissionIfNoLevel) {
        return this.getLevelFor(subject, key).orElseGet(() -> this.testPermissionFor(subject, permissionIfNoLevel) ? 1 : 0);
    }

    public boolean isPermissionLevelOkay(Subject var1, String var2, String var3, boolean var4);

    public static interface Mutable<C extends CommandSource>
    extends ICommandContext<C> {
        public <T> void put(String var1, Class<T> var2, T var3);

        public <T> void putAll(String var1, Class<T> var2, Collection<? extends T> var3);

        public void removeModifier(String var1);

        public void removeModifier(ICommandModifier var1);

        public void addFailAction(Consumer<ICommandContext<C>> var1);
    }
}

