/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command.parameter;

import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import java.util.List;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.service.permission.Subject;

public class IfConditionElseArgument
extends CommandElement {
    private final Condition predicate;
    private final CommandElement trueElement;
    private final CommandElement falseElement;
    private final IPermissionService permissionService;

    public static IfConditionElseArgument permission(IPermissionService permissionService, String permission, CommandElement ifSo, CommandElement ifNot) {
        return new IfConditionElseArgument(permissionService, ifSo, ifNot, (p, s, c) -> p.hasPermission((Subject)s, permission));
    }

    public IfConditionElseArgument(IPermissionService permissionService, CommandElement trueElement, CommandElement falseElement, Condition predicate) {
        super(trueElement.getKey());
        this.permissionService = permissionService;
        this.trueElement = trueElement;
        this.falseElement = falseElement;
        this.predicate = predicate;
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) {
        return null;
    }

    public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
        if (this.predicate.test(this.permissionService, source, context)) {
            this.trueElement.parse(source, args, context);
        } else {
            this.falseElement.parse(source, args, context);
        }
    }

    public List<String> complete(CommandSource source, CommandArgs args, CommandContext context) {
        if (this.predicate.test(this.permissionService, source, context)) {
            return this.trueElement.complete(source, args, context);
        }
        return this.falseElement.complete(source, args, context);
    }

    @FunctionalInterface
    public static interface Condition {
        public boolean test(IPermissionService var1, CommandSource var2, CommandContext var3);
    }
}

