/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.messageprovider;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.github.nucleuspowered.nucleus.api.core.NucleusUserPreferenceService;
import io.github.nucleuspowered.nucleus.guice.ConfigDirectory;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.messageprovider.repository.ConfigFileMessagesRepository;
import io.github.nucleuspowered.nucleus.services.impl.messageprovider.repository.IMessageRepository;
import io.github.nucleuspowered.nucleus.services.impl.messageprovider.repository.PropertiesMessageRepository;
import io.github.nucleuspowered.nucleus.services.impl.messageprovider.repository.UTF8Control;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.IUserPreferenceService;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.translation.locale.Locales;

@Singleton
public class MessageProviderService
implements IMessageProviderService,
IReloadableService.Reloadable {
    private static final String LANGUAGE_KEY_PREFIX = "language.";
    private static final String MESSAGES_BUNDLE = "assets.nucleus.messages";
    private static final String MESSAGES_BUNDLE_RESOURCE_LOC = "messages_{0}.properties";
    private static final Set<Locale> KNOWN_LOCALES = ImmutableSet.builder().add((Object)Locale.UK).add((Object)Locale.FRANCE).add((Object)Locale.GERMANY).add((Object)Locales.ES_ES).add((Object)Locale.ITALY).add((Object)Locales.PT_BR).add((Object)Locale.SIMPLIFIED_CHINESE).add((Object)Locale.TRADITIONAL_CHINESE).add((Object)Locales.RU_RU).build();
    private static final Map<String, Locale> LOCALES = new HashMap<String, Locale>();
    private final INucleusServiceCollection serviceCollection;
    private final IUserPreferenceService userPreferenceService;
    private Locale defaultLocale = Sponge.getServer().getConsole().getLocale();
    private boolean useMessagesFile;
    private boolean useClientLocalesWhenPossible;
    private final PropertiesMessageRepository defaultMessagesResource;
    private final ConfigFileMessagesRepository configFileMessagesRepository;
    private final Map<Locale, PropertiesMessageRepository> messagesMap = new HashMap<Locale, PropertiesMessageRepository>();
    private final LoadingCache<UUID, Locale> localeCache = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<UUID, Locale>(){

        @CheckForNull
        public Locale load(@Nonnull UUID key) {
            NucleusUserPreferenceService.PreferenceKey<Locale> l = MessageProviderService.this.userPreferenceService.keys().playerLocale().get();
            return MessageProviderService.this.userPreferenceService.get(key, l).orElse(new Locale(""));
        }
    });

    @Inject
    public MessageProviderService(INucleusServiceCollection serviceCollection, @ConfigDirectory Path configPath) {
        this.serviceCollection = serviceCollection;
        serviceCollection.reloadableService().registerReloadable(this);
        this.defaultMessagesResource = new PropertiesMessageRepository(serviceCollection.textStyleService(), serviceCollection.playerDisplayNameService(), ResourceBundle.getBundle(MESSAGES_BUNDLE, Locale.ROOT, UTF8Control.INSTANCE));
        this.configFileMessagesRepository = new ConfigFileMessagesRepository(serviceCollection.textStyleService(), serviceCollection.playerDisplayNameService(), serviceCollection.logger(), configPath.resolve("messages.conf"), () -> this.getPropertiesMessagesRepository(this.defaultLocale));
        this.userPreferenceService = serviceCollection.userPreferenceService();
    }

    @Override
    public boolean hasKey(String key) {
        return this.getMessagesRepository(this.defaultLocale).hasEntry(key);
    }

    @Override
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public Optional<Locale> getLocaleFromName(String l) {
        if (LOCALES.isEmpty()) {
            for (Locale locale : KNOWN_LOCALES) {
                for (Locale innerLocale : KNOWN_LOCALES) {
                    String key = LANGUAGE_KEY_PREFIX + innerLocale.toString().toLowerCase(Locale.ENGLISH);
                    String name = this.getPropertiesMessagesRepository(locale).getString(key).toLowerCase(Locale.ENGLISH);
                    if (LOCALES.containsKey(name)) continue;
                    LOCALES.put(name, innerLocale);
                }
                LOCALES.put(locale.toString().toLowerCase(Locale.ENGLISH), locale);
            }
        }
        return Optional.ofNullable(LOCALES.get(l.toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public void invalidateLocaleCacheFor(UUID uuid) {
        this.localeCache.invalidate((Object)uuid);
    }

    @Override
    public Locale getLocaleFor(CommandSource commandSource) {
        Locale l;
        if (commandSource instanceof User && (l = (Locale)this.localeCache.get((Object)((User)commandSource).getUniqueId())) != null && !l.toString().isEmpty()) {
            return l;
        }
        Locale toUse = this.useClientLocalesWhenPossible ? commandSource.getLocale() : this.defaultLocale;
        return toUse;
    }

    @Override
    public Text getMessageFor(Locale locale, String key) {
        return this.getMessagesRepository(locale).getText(key);
    }

    @Override
    public Text getMessageFor(Locale locale, String key, Text ... args) {
        return this.getMessagesRepository(locale).getText(key, args);
    }

    @Override
    public Text getMessageFor(Locale locale, String key, Object ... replacements) {
        return this.getMessagesRepository(locale).getText(key, replacements);
    }

    @Override
    public Text getMessageFor(Locale locale, String key, String ... replacements) {
        return this.getMessagesRepository(locale).getText(key, replacements);
    }

    @Override
    public String getMessageString(Locale locale, String key, String ... replacements) {
        return this.getMessagesRepository(locale).getString(key, replacements);
    }

    @Override
    public String getMessageString(Locale locale, String key, Object ... replacements) {
        return this.getMessagesRepository(locale).getString(key, replacements);
    }

    @Override
    public boolean reloadMessageFile() {
        if (this.useMessagesFile) {
            this.configFileMessagesRepository.invalidateIfNecessary();
            return true;
        }
        return false;
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        CoreConfig coreConfig = serviceCollection.moduleDataProvider().getModuleConfig(CoreConfig.class);
        boolean firstLoad = coreConfig.isCustommessages() && !this.useMessagesFile;
        this.useMessagesFile = coreConfig.isCustommessages();
        if (firstLoad) {
            this.configFileMessagesRepository.invalidateIfNecessary(true);
        }
        this.useClientLocalesWhenPossible = coreConfig.isClientLocaleWhenPossible();
        this.defaultLocale = Locale.forLanguageTag(coreConfig.getServerLocale().replace("_", "-"));
        this.serviceCollection.logger().info(this.getMessageString("language.set", this.defaultLocale.toLanguageTag()));
        this.reloadMessageFile();
    }

    @Override
    public IMessageRepository getMessagesRepository(Locale locale) {
        if (this.useMessagesFile) {
            return this.configFileMessagesRepository;
        }
        return this.getPropertiesMessagesRepository(locale);
    }

    @Override
    public ConfigFileMessagesRepository getConfigFileMessageRepository() {
        return this.configFileMessagesRepository;
    }

    @Override
    public String getTimeString(Locale locale, Duration duration) {
        return this.getTimeString(locale, duration.getSeconds());
    }

    @Override
    public String getTimeString(Locale locale, long time) {
        time = Math.abs(time);
        long sec = time % 60L;
        long min = time / 60L % 60L;
        long hour = time / 3600L % 24L;
        long day = time / 86400L;
        if (time == 0L) {
            return this.getMessageString(locale, "standard.inamoment", new String[0]);
        }
        StringBuilder sb = new StringBuilder();
        if (day > 0L) {
            sb.append(day).append(" ");
            if (day > 1L) {
                sb.append(this.getMessageString(locale, "standard.days", new String[0]));
            } else {
                sb.append(this.getMessageString(locale, "standard.day", new String[0]));
            }
        }
        if (hour > 0L) {
            this.appendComma(sb);
            sb.append(hour).append(" ");
            if (hour > 1L) {
                sb.append(this.getMessageString(locale, "standard.hours", new String[0]));
            } else {
                sb.append(this.getMessageString(locale, "standard.hour", new String[0]));
            }
        }
        if (min > 0L) {
            this.appendComma(sb);
            sb.append(min).append(" ");
            if (min > 1L) {
                sb.append(this.getMessageString(locale, "standard.minutes", new String[0]));
            } else {
                sb.append(this.getMessageString(locale, "standard.minute", new String[0]));
            }
        }
        if (sec > 0L) {
            this.appendComma(sb);
            sb.append(sec).append(" ");
            if (sec > 1L) {
                sb.append(this.getMessageString(locale, "standard.seconds", new String[0]));
            } else {
                sb.append(this.getMessageString(locale, "standard.second", new String[0]));
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return this.getMessageString(locale, "standard.unknown", new String[0]);
    }

    @Override
    public List<String> getAllLocaleNames() {
        return ImmutableList.copyOf(LOCALES.keySet());
    }

    private void appendComma(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(", ");
        }
    }

    private PropertiesMessageRepository getPropertiesMessagesRepository(Locale locale) {
        return this.messagesMap.computeIfAbsent(locale, key -> {
            if (Sponge.getAssetManager().getAsset((Object)this.serviceCollection.pluginContainer(), MessageFormat.format(MESSAGES_BUNDLE_RESOURCE_LOC, locale.toString())).isPresent()) {
                return new PropertiesMessageRepository(this.serviceCollection.textStyleService(), this.serviceCollection.playerDisplayNameService(), ResourceBundle.getBundle(MESSAGES_BUNDLE, locale, UTF8Control.INSTANCE));
            }
            return this.defaultMessagesResource;
        });
    }
}

