/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.placeholder.standard;

import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import java.util.Optional;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.placeholder.PlaceholderContext;
import org.spongepowered.api.text.placeholder.PlaceholderParser;
import org.spongepowered.api.text.serializer.FormattingCodeTextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;

public class NamedOptionPlaceholder
implements PlaceholderParser {
    private final IPermissionService permissionService;
    private final String namedOption;

    public NamedOptionPlaceholder(IPermissionService permissionService, String namedOption) {
        this.permissionService = permissionService;
        this.namedOption = namedOption;
    }

    public Text parse(PlaceholderContext placeholderContext) {
        Optional<Subject> subjectOptional = placeholderContext.getAssociatedObject().filter(x -> x instanceof Subject).map(x -> (Subject)x);
        return subjectOptional.flatMap(subject -> this.permissionService.getOptionFromSubject((Subject)subject, this.namedOption).map(arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.FORMATTING_CODE).deserialize(arg_0))).orElse(Text.EMPTY);
    }

    public String getId() {
        return "nucleus:option_" + this.namedOption;
    }

    public String getName() {
        return "Nucleus Named Permission Option Placeholder (" + this.namedOption + ")";
    }
}

