/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.textstyle;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.ITextStyleService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextElement;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.serializer.TextSerializers;

@Singleton
public class TextStyleService
implements ITextStyleService,
IReloadableService.Reloadable {
    private final Pattern COLOURS = Pattern.compile(".*?(?<colour>(&[0-9a-flmnrok])+)$");
    private final Pattern URL_PARSER = Pattern.compile("(?<first>(^|\\s))(?<reset>&r)?(?<colour>(&[0-9a-flmnrok])+)?(?<options>\\{[a-z]+?})?(?<url>(http(s)?://)?([A-Za-z0-9-]+\\.)+[A-Za-z0-9]{2,}\\S*)", 2);
    private static final ITextStyleService.TextFormat EMPTY = new TextFormatImpl(TextColors.NONE, TextStyles.NONE);
    private final Logger logger;
    private final IPermissionService permissionService;
    private final IMessageProviderService messageProviderService;
    private final BiMap<TextColor, String> colourToPermissionSuffix = HashBiMap.create((Map)ImmutableMap.builder().put((Object)TextColors.AQUA, (Object)"aqua").put((Object)TextColors.BLACK, (Object)"black").put((Object)TextColors.BLUE, (Object)"blue").put((Object)TextColors.DARK_AQUA, (Object)"dark_aqua").put((Object)TextColors.DARK_BLUE, (Object)"dark_blue").put((Object)TextColors.DARK_GRAY, (Object)"dark_gray").put((Object)TextColors.DARK_GREEN, (Object)"dark_green").put((Object)TextColors.DARK_PURPLE, (Object)"dark_purple").put((Object)TextColors.DARK_RED, (Object)"dark_red").put((Object)TextColors.GOLD, (Object)"gold").put((Object)TextColors.GRAY, (Object)"gray").put((Object)TextColors.GREEN, (Object)"green").put((Object)TextColors.LIGHT_PURPLE, (Object)"light_purple").put((Object)TextColors.NONE, (Object)"").put((Object)TextColors.RED, (Object)"red").put((Object)TextColors.RESET, (Object)"reset").put((Object)TextColors.WHITE, (Object)"white").put((Object)TextColors.YELLOW, (Object)"yellow").build());
    private final BiMap<Character, TextColor> idToColour = HashBiMap.create((Map)ImmutableMap.builder().put((Object)Character.valueOf('0'), (Object)TextColors.BLACK).put((Object)Character.valueOf('1'), (Object)TextColors.DARK_BLUE).put((Object)Character.valueOf('2'), (Object)TextColors.DARK_GREEN).put((Object)Character.valueOf('3'), (Object)TextColors.DARK_AQUA).put((Object)Character.valueOf('4'), (Object)TextColors.DARK_RED).put((Object)Character.valueOf('5'), (Object)TextColors.DARK_PURPLE).put((Object)Character.valueOf('6'), (Object)TextColors.GOLD).put((Object)Character.valueOf('7'), (Object)TextColors.GRAY).put((Object)Character.valueOf('8'), (Object)TextColors.DARK_GRAY).put((Object)Character.valueOf('9'), (Object)TextColors.BLUE).put((Object)Character.valueOf('a'), (Object)TextColors.GREEN).put((Object)Character.valueOf('b'), (Object)TextColors.AQUA).put((Object)Character.valueOf('c'), (Object)TextColors.RED).put((Object)Character.valueOf('d'), (Object)TextColors.LIGHT_PURPLE).put((Object)Character.valueOf('e'), (Object)TextColors.YELLOW).put((Object)Character.valueOf('f'), (Object)TextColors.WHITE).put((Object)Character.valueOf('r'), (Object)TextColors.RESET).build());
    private final HashBiMap<TextStyle, String> styleToPerms = HashBiMap.create((Map)ImmutableMap.builder().put((Object)TextStyles.BOLD, (Object)"bold").put((Object)TextStyles.ITALIC, (Object)"italic").put((Object)TextStyles.UNDERLINE, (Object)"underline").put((Object)TextStyles.STRIKETHROUGH, (Object)"strikethrough").put((Object)TextStyles.OBFUSCATED, (Object)"obfuscated").build());
    private final BiMap<Character, TextStyle> idToStyle = HashBiMap.create((Map)ImmutableMap.builder().put((Object)Character.valueOf('l'), (Object)TextStyles.BOLD).put((Object)Character.valueOf('o'), (Object)TextStyles.ITALIC).put((Object)Character.valueOf('n'), (Object)TextStyles.UNDERLINE).put((Object)Character.valueOf('m'), (Object)TextStyles.STRIKETHROUGH).put((Object)Character.valueOf('k'), (Object)TextStyles.OBFUSCATED).build());

    @Inject
    public TextStyleService(IReloadableService reloadableService, IPermissionService permissionService, IMessageProviderService messageProviderService, Logger logger) {
        this.permissionService = permissionService;
        this.messageProviderService = messageProviderService;
        this.logger = logger;
        reloadableService.registerReloadable(this);
    }

    @Override
    public Optional<String> getPermissionFor(String prefix, TextColor colour) {
        String r;
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        if ((r = (String)this.colourToPermissionSuffix.get((Object)colour)) == null) {
            String[] n = colour.getId().split(":", 2);
            String name = (n.length == 2 ? n[1] : n[0]).toLowerCase(Locale.ENGLISH);
            this.colourToPermissionSuffix.put((Object)colour, (Object)name);
            return Optional.of(prefix + name);
        }
        if (r.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(prefix + r);
    }

    @Override
    public List<String> getPermissionsFor(String prefix, TextStyle style) {
        String p;
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        if ((p = (String)this.styleToPerms.get((Object)style)) != null) {
            return ImmutableList.of((Object)(prefix + p));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        TextStyleService.addStylePermIf(style.hasStrikethrough().orElse(false), prefix, "strikethrough", (ImmutableList.Builder<String>)builder);
        TextStyleService.addStylePermIf(style.hasUnderline().orElse(false), prefix, "underline", (ImmutableList.Builder<String>)builder);
        TextStyleService.addStylePermIf(style.isBold().orElse(false), prefix, "bold", (ImmutableList.Builder<String>)builder);
        TextStyleService.addStylePermIf(style.isItalic().orElse(false), prefix, "italic", (ImmutableList.Builder<String>)builder);
        TextStyleService.addStylePermIf(style.isObfuscated().orElse(false), prefix, "obfuscated", (ImmutableList.Builder<String>)builder);
        return builder.build();
    }

    @Override
    public String stripPermissionless(String permissionPrefixColour, String permissionPrefixStyle, Subject source, String oldMessage) {
        return this.stripPermissionless(Collections.singletonList(permissionPrefixColour), permissionPrefixStyle, source, oldMessage);
    }

    @Override
    public String stripPermissionless(String permissionPrefixColour, String permissionPrefixColor, String permissionPrefixStyle, Subject source, String oldMessage) {
        return this.stripPermissionless(Arrays.asList(permissionPrefixColour, permissionPrefixColor), permissionPrefixStyle, source, oldMessage);
    }

    private String stripPermissionless(List<String> permissionPrefixColour, String permissionPrefixStyle, Subject source, String oldMessage) {
        String p;
        String message = oldMessage;
        if (message.contains("&") && (p = this.getRegexForPermissionless(source, permissionPrefixColour, permissionPrefixStyle)) != null) {
            int oldlength;
            while ((oldlength = message.length()) != (message = message.replaceAll(p, "")).length()) {
            }
        }
        return message;
    }

    @Override
    public Collection<String> wouldStrip(Collection<String> permissionPrefixColour, String permissionPrefixStyle, Subject source, String text) {
        return this.wouldStrip((List<String>)new ArrayList<String>(permissionPrefixColour), permissionPrefixStyle, source, text);
    }

    private Collection<String> wouldStrip(List<String> permissionPrefixColour, String permissionPrefixStyle, Subject source, String oldMessage) {
        Pattern pattern;
        String p;
        if (oldMessage.contains("&") && (p = this.getRegexForPermissionless(source, permissionPrefixColour, permissionPrefixStyle)) != null && (pattern = Pattern.compile(p)).matcher(oldMessage).find()) {
            ImmutableList.Builder name = ImmutableList.builder();
            for (char a : p.toCharArray()) {
                if (a == '&' || a == '[' || a == ']') continue;
                TextColor textColor = (TextColor)this.idToColour.get((Object)Character.valueOf(a));
                if (textColor != null) {
                    name.add((Object)textColor.getName());
                    continue;
                }
                name.add(this.styleToPerms.get(this.idToStyle.get((Object)Character.valueOf(a))));
            }
            return name.build();
        }
        return Collections.emptyList();
    }

    private static void addStylePermIf(boolean condition, String prefix, String suffix, ImmutableList.Builder<String> builder) {
        if (condition) {
            builder.add((Object)(prefix + suffix));
        }
    }

    @Nullable
    private String getRegexForPermissionless(Subject subject, List<String> permissionPrefixColour, String stylePrefix) {
        String keys = this.getKeys(subject, permissionPrefixColour, stylePrefix);
        if (keys != null) {
            return "&[" + keys + "]";
        }
        return null;
    }

    @Nullable
    private String getKeys(Subject subject, List<String> permissionPrefixColour, String stylePrefix) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry suffix : this.colourToPermissionSuffix.entrySet()) {
            Character c;
            if (!permissionPrefixColour.stream().noneMatch(prefix -> {
                String p = prefix.endsWith(".") ? prefix : prefix + ".";
                return this.permissionService.hasPermission(subject, p + (String)suffix.getValue());
            }) || (c = (Character)this.idToColour.inverse().get(suffix.getKey())) == null) continue;
            stringBuilder.append(c);
        }
        String p = stylePrefix.endsWith(".") ? stylePrefix : stylePrefix + ".";
        for (Map.Entry suffix : this.styleToPerms.entrySet()) {
            Character c;
            if (this.permissionService.hasPermission(subject, p + (String)suffix.getValue()) || (c = (Character)this.idToStyle.inverse().get(suffix.getKey())) == null) continue;
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    public ITextStyleService.TextFormat getLastColourAndStyle(TextRepresentable text, @Nullable ITextStyleService.TextFormat current, TextColor defaultColour, TextStyle defaultStyle) {
        List<Text> texts = this.flatten(text.toText());
        if (texts.isEmpty()) {
            return current == null ? new TextFormatImpl(defaultColour, defaultStyle) : current;
        }
        TextColor tc = TextColors.NONE;
        TextStyle ts = texts.get(texts.size() - 1).getStyle();
        for (int i = texts.size() - 1; i > -1 && (tc = texts.get(i).getColor()) == TextColors.NONE; --i) {
        }
        if (tc == TextColors.NONE) {
            tc = defaultColour;
        }
        if (current == null) {
            return new TextFormatImpl(tc, ts);
        }
        return new TextFormatImpl(tc != TextColors.NONE ? tc : current.colour(), ts);
    }

    private List<Text> flatten(Text text) {
        ArrayList texts = Lists.newArrayList((Object[])new Text[]{text});
        if (!text.getChildren().isEmpty()) {
            text.getChildren().forEach(x -> texts.addAll(this.flatten((Text)x)));
        }
        return texts;
    }

    @Override
    public TextColor getColourFromString(@Nullable String s) {
        if (s == null || s.length() == 0) {
            return TextColors.NONE;
        }
        if (s.length() == 1) {
            return (TextColor)this.idToColour.getOrDefault((Object)Character.valueOf(s.charAt(0)), (Object)TextColors.NONE);
        }
        return Sponge.getRegistry().getType(TextColor.class, s.toUpperCase()).orElse(TextColors.NONE);
    }

    @Override
    public TextStyle getTextStyleFromString(@Nullable String s) {
        if (s == null || s.length() == 0) {
            return TextStyles.NONE;
        }
        TextStyle ts = TextStyles.NONE;
        for (String split : s.split("\\s*,\\s*")) {
            ts = split.length() == 1 ? ts.and(new TextStyle[]{(TextStyle)this.idToStyle.getOrDefault((Object)Character.valueOf(split.charAt(0)), (Object)TextStyles.NONE)}) : ts.and(new TextStyle[]{(TextStyle)this.styleToPerms.inverse().getOrDefault((Object)split.toLowerCase(), (Object)TextStyles.NONE)});
        }
        return ts;
    }

    @Override
    public Text addUrls(String message) {
        return this.addUrls(message, false);
    }

    @Override
    public Text addUrls(String message, boolean replaceBlueUnderline) {
        if (message == null || message.isEmpty()) {
            return Text.EMPTY;
        }
        Matcher m = this.URL_PARSER.matcher(message);
        if (!m.find()) {
            return TextSerializers.FORMATTING_CODE.deserialize(message);
        }
        ArrayList texts = Lists.newArrayList();
        String remaining = message;
        ITextStyleService.TextFormat st = EMPTY;
        do {
            String[] textArray = remaining.split(this.URL_PARSER.pattern(), 2);
            Text first = Text.builder().color(st.colour()).style(new TextStyle[]{st.style()}).append(new Text[]{TextSerializers.FORMATTING_CODE.deserialize(textArray[0])}).build();
            texts.add(first);
            remaining = textArray.length == 2 ? textArray[1] : null;
            String colourMatch = m.group("colour");
            if (replaceBlueUnderline) {
                st = new TextFormatImpl(TextColors.BLUE, (TextStyle)TextStyles.UNDERLINE);
            } else if (colourMatch != null && !colourMatch.isEmpty()) {
                TextStyle reset = TextStyles.NONE;
                if (m.group("reset") != null) {
                    reset = TextStyles.RESET;
                }
                st = this.getLastColourAndStyle((TextRepresentable)Text.of((Object[])new Object[]{reset, TextSerializers.FORMATTING_CODE.deserialize(m.group("colour") + " ")}), st);
            } else {
                st = this.getLastColourAndStyle((TextRepresentable)first, st);
            }
            String whiteSpace = m.group("first");
            st = replaceBlueUnderline ? new TextFormatImpl(TextColors.BLUE, (TextStyle)TextStyles.UNDERLINE) : this.getLastColourAndStyle((TextRepresentable)first, st);
            String url = m.group("url");
            if (url.endsWith("&r")) {
                String url2 = url.replaceAll("&r$", "");
                texts.add(this.getTextForUrl(url2, url2, whiteSpace, st, m.group("options")));
            } else {
                texts.add(this.getTextForUrl(url, url, whiteSpace, st, m.group("options")));
            }
            if (!replaceBlueUnderline) continue;
            st = this.getLastColourAndStyle((TextRepresentable)first, st, TextColors.WHITE, TextStyles.NONE);
        } while (remaining != null && m.find());
        if (remaining != null) {
            texts.add(Text.builder().color(st.colour()).style(new TextStyle[]{st.style()}).append(new Text[]{TextSerializers.FORMATTING_CODE.deserialize(remaining)}).build());
        }
        return Text.of((Object[])texts.toArray(new TextElement[texts.size()]));
    }

    @Override
    public Text getTextForUrl(String url, String msg, String whiteSpace, ITextStyleService.TextFormat st, @Nullable String optionString) {
        String toParse = TextSerializers.FORMATTING_CODE.stripCodes(url);
        try {
            URL urlObj = !toParse.startsWith("http://") && !toParse.startsWith("https://") ? new URL("http://" + toParse) : new URL(toParse);
            LiteralText.Builder textBuilder = Text.builder((String)msg).color(st.colour()).style(new TextStyle[]{st.style()}).onClick((ClickAction)TextActions.openUrl((URL)urlObj));
            if (optionString == null || !optionString.contains("h")) {
                textBuilder.onHover((HoverAction)TextActions.showText((Text)this.messageProviderService.getMessage("chat.url.click", url)));
            }
            if (!whiteSpace.isEmpty()) {
                return Text.builder((String)whiteSpace).append(new Text[]{textBuilder.build()}).build();
            }
            return textBuilder.build();
        }
        catch (MalformedURLException e) {
            this.logger.warn(this.messageProviderService.getMessageString("chat.url.malformed", url));
            e.printStackTrace();
            LiteralText ret = Text.builder((String)url).color(st.colour()).style(new TextStyle[]{st.style()}).build();
            if (!whiteSpace.isEmpty()) {
                return Text.builder((String)whiteSpace).append(new Text[]{ret}).build();
            }
            return ret;
        }
    }

    @Override
    public Text oldLegacy(String message) {
        Matcher colourMatcher = this.COLOURS.matcher(message);
        if (colourMatcher.matches()) {
            Text first = TextSerializers.FORMATTING_CODE.deserialize(message.replace(colourMatcher.group("colour"), ""));
            String match = colourMatcher.group("colour") + " ";
            Text t = TextSerializers.FORMATTING_CODE.deserialize(match);
            return Text.of((Object[])new Object[]{first, t.getColor(), first.getStyle().and(new TextStyle[]{t.getStyle()})});
        }
        return TextSerializers.FORMATTING_CODE.deserialize(message);
    }

    @Override
    public Text joinTextsWithColoursFlowing(Text ... texts) {
        ArrayList result = Lists.newArrayList();
        Text last = null;
        for (Text n : texts) {
            if (last != null) {
                ITextStyleService.TextFormat st = this.getLastColourAndStyle((TextRepresentable)last, null);
                result.add(Text.of((Object[])new Object[]{st.colour(), st.style(), n}));
            } else {
                result.add(n);
            }
            last = n;
        }
        return Text.join((Iterable)result);
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        String commandNameOnClick = serviceCollection.moduleDataProvider().getModuleConfig(CoreConfig.class).getCommandOnNameClick();
    }

    public static class TextFormatImpl
    implements ITextStyleService.TextFormat {
        private final TextColor colour;
        private final TextStyle style;

        TextFormatImpl(TextColor colour, TextStyle style) {
            this.colour = colour;
            this.style = style;
        }

        @Override
        public TextColor colour() {
            return this.colour;
        }

        @Override
        public TextStyle style() {
            return this.style;
        }

        @Override
        public Text textOf() {
            Text.Builder tb = Text.builder();
            if (this.colour != TextColors.NONE) {
                tb.color(this.colour);
            }
            tb.style(new TextStyle[]{this.style});
            return tb.toText();
        }
    }
}

