/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.interfaces;

import com.google.inject.ImplementedBy;
import io.github.nucleuspowered.nucleus.services.impl.playername.PlayerDisplayNameService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;

@ImplementedBy(value=PlayerDisplayNameService.class)
public interface IPlayerDisplayNameService {
    public void provideDisplayNameResolver(DisplayNameResolver var1);

    public void provideDisplayNameQuery(DisplayNameQuery var1);

    public Optional<User> getUser(Text var1);

    public Optional<User> getUser(String var1);

    public Optional<Player> getPlayer(Text var1);

    public Optional<Player> getPlayer(String var1);

    public Map<UUID, List<String>> startsWith(String var1);

    public Text getDisplayName(UUID var1);

    default public Text getDisplayName(Player player) {
        return this.getDisplayName(player.getUniqueId());
    }

    default public Text getDisplayName(User user) {
        return this.getDisplayName(user.getUniqueId());
    }

    public Text getDisplayName(CommandSource var1);

    public Text getName(CommandSource var1);

    public Text addCommandToName(CommandSource var1);

    public Text addCommandToDisplayName(CommandSource var1);

    public static interface DisplayNameQuery {
        public Optional<User> resolve(String var1);

        public Map<UUID, String> startsWith(String var1);
    }

    @FunctionalInterface
    public static interface DisplayNameResolver {
        public Optional<Text> resolve(UUID var1);
    }
}

