/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.annotations.DoNotSave;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.AbstractAdaptableConfig;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.transformation.TransformAction;

public abstract class AbstractConfigAdapter<R> {
    private AbstractAdaptableConfig<?> attachedConfig = null;
    private Supplier<ConfigurationNode> nodeGetter = null;
    private Supplier<ConfigurationNode> nodeCreator = null;
    private Consumer<ConfigurationNode> nodeSaver = null;
    @Nullable
    private String module = null;
    @Nullable
    private String header = null;

    final void attachConfig(String module, AbstractAdaptableConfig<?> adapter, Supplier<ConfigurationNode> nodeGetter, Consumer<ConfigurationNode> nodeSaver, Supplier<ConfigurationNode> nodeCreator, @Nullable String header) {
        Preconditions.checkState((this.attachedConfig == null ? 1 : 0) != 0);
        this.module = module;
        this.attachedConfig = adapter;
        this.nodeGetter = nodeGetter;
        this.nodeSaver = nodeSaver;
        this.nodeCreator = nodeCreator;
        this.header = header;
        this.onAttach(module, adapter);
    }

    final void detachConfig() {
        Preconditions.checkState((this.attachedConfig != null ? 1 : 0) != 0);
        this.onDetach(this.module, this.attachedConfig);
        this.module = null;
        this.attachedConfig = null;
        this.nodeGetter = null;
        this.nodeSaver = null;
        this.nodeCreator = null;
        this.header = null;
    }

    public void onAttach(String module, AbstractAdaptableConfig<?> adapter) {
    }

    public void onDetach(String module, AbstractAdaptableConfig<?> adapter) {
    }

    public final boolean isAttached() {
        return this.attachedConfig != null;
    }

    public final ConfigurationNode getDefaults() {
        return this.generateDefaults(this.nodeGetter.get());
    }

    public final Optional<AbstractAdaptableConfig<?>> getConfig() {
        return Optional.ofNullable(this.attachedConfig);
    }

    public final R getNode() throws ObjectMappingException {
        Preconditions.checkState((this.attachedConfig != null ? 1 : 0) != 0, (Object)"You must attach this adapter before using it.");
        return this.convertFromConfigurateNode(this.nodeGetter.get());
    }

    public final void setNode(R data) throws ObjectMappingException {
        Preconditions.checkState((this.attachedConfig != null ? 1 : 0) != 0, (Object)"You must attach this adapter before using it.");
        ConfigurationNode node = this.insertIntoConfigurateNode(this.getNewNode(), data);
        if (this.header != null && node instanceof CommentedConfigurationNode) {
            CommentedConfigurationNode ccn = (CommentedConfigurationNode)node;
            ccn.setComment(this.header);
        }
        this.nodeSaver.accept(node);
    }

    final void refreshConfigurationNode() throws ObjectMappingException {
        if (this.getClass().isAnnotationPresent(DoNotSave.class)) {
            ConfigurationNode cn;
            if (this.header != null && (cn = this.nodeGetter.get()) instanceof CommentedConfigurationNode) {
                this.nodeSaver.accept((ConfigurationNode)((CommentedConfigurationNode)cn).setComment(this.header));
            }
        } else {
            this.setNode(this.getNode());
        }
    }

    protected final ConfigurationNode getNewNode() {
        Preconditions.checkState((this.attachedConfig != null ? 1 : 0) != 0, (Object)"You must attach this adapter before using it.");
        return this.nodeCreator.get();
    }

    protected Optional<String> getAssignedModule() {
        return Optional.ofNullable(this.module);
    }

    protected void manualTransform(ConfigurationNode node) {
    }

    protected List<Transformation> getTransformations() {
        return Lists.newArrayList();
    }

    protected abstract ConfigurationNode generateDefaults(ConfigurationNode var1);

    protected abstract R convertFromConfigurateNode(ConfigurationNode var1) throws ObjectMappingException;

    protected abstract ConfigurationNode insertIntoConfigurateNode(ConfigurationNode var1, R var2) throws ObjectMappingException;

    public static final class Transformation {
        private final Object[] objectPath;
        private final TransformAction action;

        public static Transformation moveTopLevel(String topLevel, String ... to) {
            return new Transformation(new Object[]{topLevel}, (i, v) -> to);
        }

        public static From moveFrom(String ... from) {
            return new From(from);
        }

        public Transformation(Object[] objectPath, TransformAction action) {
            this.objectPath = objectPath;
            this.action = action;
        }

        Object[] getObjectPath() {
            return this.objectPath;
        }

        TransformAction getAction() {
            return this.action;
        }

        public static final class From {
            private final Object[] from;

            private From(Object[] from) {
                this.from = from;
            }

            public Transformation to(String ... to) {
                return new Transformation(this.from, (i, v) -> to);
            }
        }
    }
}

