/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config;

import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.AbstractConfigAdapter;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public abstract class TypedAbstractConfigAdapter<R>
extends AbstractConfigAdapter<R> {
    public final R getNodeOrDefault() {
        try {
            Object node = this.getNode();
            if (node != null) {
                return node;
            }
        }
        catch (ObjectMappingException objectMappingException) {
            // empty catch block
        }
        return this.getDefaultObject();
    }

    protected abstract R getDefaultObject();

    @Override
    protected ConfigurationNode generateDefaults(ConfigurationNode node) {
        R o = this.getDefaultObject();
        try {
            return node.setValue(TypeToken.of(o.getClass()), o);
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return node;
        }
    }

    public static abstract class StandardWithSimpleDefault<R>
    extends Standard<R> {
        public StandardWithSimpleDefault(Class<R> clazz) {
            super(clazz);
        }

        public StandardWithSimpleDefault(TypeToken<R> typeToken) {
            super(typeToken);
        }

        @Override
        protected R getDefaultObject() {
            try {
                return (R)this.typeToken.getRawType().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static abstract class Standard<R>
    extends TypedAbstractConfigAdapter<R> {
        final TypeToken<R> typeToken;

        public Standard(Class<R> clazz) {
            this(TypeToken.of(clazz));
        }

        public Standard(TypeToken<R> typeToken) {
            this.typeToken = typeToken;
        }

        @Override
        protected R convertFromConfigurateNode(ConfigurationNode node) throws ObjectMappingException {
            return (R)node.getValue(this.typeToken, this.getDefaultObject());
        }

        @Override
        protected ConfigurationNode insertIntoConfigurateNode(ConfigurationNode newNode, R data) throws ObjectMappingException {
            return newNode.setValue(this.typeToken, data);
        }
    }
}

