/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.stevekunglib.utils;

import java.util.Map;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import stevekung.mods.stevekunglib.utils.JsonUtils;

public class VersionChecker {
    private final Object mod;
    private final String modName;
    private final String url;
    private String latestVersion;
    private boolean failed;

    public VersionChecker(Object mod, String modName, String url) {
        this.mod = mod;
        this.modName = modName;
        this.url = url;
    }

    public void startCheck() {
        ForgeVersion.CheckResult result = ForgeVersion.getResult((ModContainer)((ModContainer)Loader.instance().getModObjectList().inverse().get(this.mod)));
        for (Map.Entry entry : result.changes.entrySet()) {
            ComparableVersion version = (ComparableVersion)entry.getKey();
            if (result.status != ForgeVersion.Status.OUTDATED) continue;
            this.latestVersion = version.toString();
        }
    }

    public void startCheckIfFailed() {
        ForgeVersion.CheckResult result = ForgeVersion.getResult((ModContainer)((ModContainer)Loader.instance().getModObjectList().inverse().get(this.mod)));
        this.failed = result.status == ForgeVersion.Status.FAILED || result.status == ForgeVersion.Status.PENDING;
    }

    public void printInfo(EntityPlayerSP player) {
        if (this.failed) {
            player.func_145747_a(JsonUtils.create("Unable to check latest version of " + this.formatText(TextFormatting.DARK_RED, this.modName + "!") + "!, Please check your internet connection.").func_150255_a(JsonUtils.red().func_150227_a(Boolean.valueOf(true))));
            return;
        }
        if (this.latestVersion != null) {
            String text = String.format("New version of %s is available %s for %s", this.formatText(TextFormatting.AQUA, this.modName), this.formatText(TextFormatting.GREEN, "v" + this.latestVersion), this.formatText(TextFormatting.BLUE, "Minecraft 1.12.2"));
            player.func_145747_a((ITextComponent)JsonUtils.create(text));
            player.func_145747_a(JsonUtils.create("Download Link ").func_150255_a(JsonUtils.style().func_150238_a(TextFormatting.YELLOW)).func_150257_a(JsonUtils.create("[CLICK HERE]").func_150255_a(JsonUtils.style().func_150238_a(TextFormatting.RED).func_150209_a(JsonUtils.hover(HoverEvent.Action.SHOW_TEXT, JsonUtils.create("Click Here!").func_150255_a(JsonUtils.style().func_150238_a(TextFormatting.DARK_GREEN)))).func_150241_a(JsonUtils.click(ClickEvent.Action.OPEN_URL, this.url)))));
        }
    }

    private String formatText(TextFormatting color, String text) {
        return color + text + TextFormatting.WHITE;
    }
}

