/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.api.world.data.storage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.romvoid95.api.world.data.ISchematic;

public class Schematic
implements ISchematic {
    private static final ItemStack DEFAULT_ICON = new ItemStack((Block)Blocks.field_150349_c);
    private ItemStack icon;
    private final short[][][] blocks;
    private final byte[][][] metadata;
    private final List<TileEntity> tileEntities = new ArrayList<TileEntity>();
    private final List<Entity> entities = new ArrayList<Entity>();
    private final int width;
    private final int height;
    private final int length;
    private String author;

    public Schematic(ItemStack icon, int width, int height, int length) {
        this(icon, width, height, length, "");
    }

    public Schematic(ItemStack icon, int width, int height, int length, @Nonnull String author) {
        if (author == null) {
            throw new IllegalArgumentException("Author cannot be null");
        }
        this.icon = icon;
        this.blocks = new short[width][height][length];
        this.metadata = new byte[width][height][length];
        this.width = width;
        this.height = height;
        this.length = length;
        this.author = author;
    }

    @Override
    public IBlockState getBlockState(BlockPos pos) {
        if (!this.isValid(pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        Block block = (Block)Block.field_149771_c.func_148754_a((int)this.blocks[x][y][z]);
        return block.func_176203_a((int)this.metadata[x][y][z]);
    }

    @Override
    public boolean setBlockState(BlockPos pos, IBlockState blockState) {
        if (!this.isValid(pos)) {
            return false;
        }
        Block block = blockState.func_177230_c();
        int id = Block.field_149771_c.func_148757_b((Object)block);
        if (id == -1) {
            return false;
        }
        int meta = block.func_176201_c(blockState);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.blocks[x][y][z] = (short)id;
        this.metadata[x][y][z] = (byte)meta;
        return true;
    }

    @Override
    public TileEntity getTileEntity(BlockPos pos) {
        for (TileEntity tileEntity : this.tileEntities) {
            if (!tileEntity.func_174877_v().equals((Object)pos)) continue;
            return tileEntity;
        }
        return null;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    @Override
    public void setTileEntity(BlockPos pos, TileEntity tileEntity) {
        if (!this.isValid(pos)) {
            return;
        }
        this.removeTileEntity(pos);
        if (tileEntity != null) {
            this.tileEntities.add(tileEntity);
        }
    }

    @Override
    public void removeTileEntity(BlockPos pos) {
        Iterator<TileEntity> iterator = this.tileEntities.iterator();
        while (iterator.hasNext()) {
            TileEntity tileEntity = iterator.next();
            if (!tileEntity.func_174877_v().equals((Object)pos)) continue;
            iterator.remove();
        }
    }

    @Override
    public List<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public void addEntity(Entity entity) {
        if (entity == null || entity.func_110124_au() == null || entity instanceof EntityPlayer) {
            return;
        }
        for (Entity e : this.entities) {
            if (!entity.func_110124_au().equals(e.func_110124_au())) continue;
            return;
        }
        this.entities.add(entity);
    }

    @Override
    public void removeEntity(Entity entity) {
        if (entity == null || entity.func_110124_au() == null) {
            return;
        }
        Iterator<Entity> iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            Entity e = iterator.next();
            if (!entity.func_110124_au().equals(e.func_110124_au())) continue;
            iterator.remove();
        }
    }

    @Override
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(ItemStack icon) {
        this.icon = icon != null ? icon : DEFAULT_ICON.func_77946_l();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    private boolean isValid(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return x >= 0 && y >= 0 && z >= 0 && x < this.width && y < this.height && z < this.length;
    }

    @Override
    @Nonnull
    public String getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(@Nonnull String author) {
        if (author == null) {
            throw new IllegalArgumentException("Author cannot be null");
        }
        this.author = author;
    }
}

