/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.galactic.modules.galacticraft;

import asmodeuscore.core.astronomy.BodiesRegistry;
import asmodeuscore.core.configs.AsmodeusConfig;
import java.io.File;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.romvoid95.api.GalacticraftAddon;
import net.romvoid95.api.module.Module;
import net.romvoid95.galactic.GalacticTweaks;
import net.romvoid95.galactic.Info;
import net.romvoid95.galactic.core.gc.IOWriter;
import net.romvoid95.galactic.modules.galacticraft.GalacticraftModuleConfig;
import net.romvoid95.galactic.modules.galacticraft.features.BreatheableDimensions;
import net.romvoid95.galactic.modules.galacticraft.features.CompressorFixes;
import net.romvoid95.galactic.modules.galacticraft.features.FixAsmodeusMapIcons;
import net.romvoid95.galactic.modules.galacticraft.features.MobsBreatheInSpace;
import net.romvoid95.galactic.modules.galacticraft.features.NoSpaceMusic;
import net.romvoid95.galactic.modules.galacticraft.features.OxygenSpawnGear;
import net.romvoid95.galactic.modules.galacticraft.features.SeperateAddonPlanets;
import net.romvoid95.galactic.modules.galacticraft.features.SpaceRaceFeature;
import net.romvoid95.galactic.modules.galacticraft.features.SpawnDimension;
import net.romvoid95.galactic.modules.galacticraft.features.UnlockSchematics;
import net.romvoid95.galactic.modules.galacticraft.features.admintools.DirectTeleporter;

public class GalacticraftModule
extends Module {
    private GalacticraftModuleConfig config = new GalacticraftModuleConfig(Info.CONFVERSION);

    @Override
    public void addClientFeatures() {
        this.registerFeature(new FixAsmodeusMapIcons());
        this.registerFeature(new NoSpaceMusic());
    }

    @Override
    public void addCommonFeatures() {
        this.registerFeature(new DirectTeleporter());
        this.registerFeature(new BreatheableDimensions());
        this.registerFeature(new CompressorFixes());
        this.registerFeature(new MobsBreatheInSpace());
        this.registerFeature(new OxygenSpawnGear());
        this.registerFeature(new SeperateAddonPlanets());
        this.registerFeature(new SpaceRaceFeature());
        this.registerFeature(new SpawnDimension());
        this.registerFeature(new UnlockSchematics());
    }

    @Override
    public void setupConfig() {
        File file = new File(GalacticTweaks.modFolder, "GalacticraftModule.cfg");
        this.config.setConfigFile(file);
        this.config.loadConfig();
        this.features.forEach(feat -> this.config.getCategory(feat.getCategory()).setComment(feat.getCategoryComment()));
    }

    @Override
    public void postInit() {
        if (GalacticraftAddon.EXTRAPLANETS.isLoaded() && GalacticraftAddon.GALAXYSPACE.isLoaded() && AsmodeusConfig.enableNewGalaxyMap) {
            BodiesRegistry.setMaxTier((int)10);
        }
        IOWriter io = new IOWriter();
        io.handleFile("ValidDimIDs.txt");
        if (GalacticraftAddon.EXTRAPLANETS.isLoaded()) {
            io.NOTICE();
            io.write("Planets & Moons that end with \"ep\" are added by ExtraPlanets.");
            io.write("Please keep this in mind if choosing a planet that is added by both ExtraPlanets & GalaxySpace");
            io.nl();
            io.write("This file is regenerated every time minecraft is ran to handle any addons added or removed");
            io.title("PLANETS");
            io.writePlanets();
            io.title("MOONS");
            io.writeMoons();
            io.finalize();
        }
        this.config.addValidDims();
        this.config.loadConfig();
        ConfigManager.sync((String)"galactictweaks", (Config.Type)Config.Type.INSTANCE);
        super.postInit();
    }
}

