/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdscheduler.schedule;

import com.google.common.base.Preconditions;
import com.mcsimonflash.sponge.cmdscheduler.internal.Utils;
import com.mcsimonflash.sponge.cmdscheduler.schedule.Schedule;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.util.ResettableBuilder;

public class ClassicSchedule
implements Schedule {
    private final long delay;
    private final boolean delayTicks;
    private final long interval;
    private final boolean intervalTicks;

    private ClassicSchedule(long delay, boolean delayTicks, long interval, boolean intervalTicks) {
        this.delay = delay;
        this.delayTicks = delayTicks;
        this.interval = interval;
        this.intervalTicks = intervalTicks;
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    @Override
    public long getDelay(Calendar calendar) {
        return this.delay;
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    public boolean isDelayTicks() {
        return this.delayTicks;
    }

    public boolean isIntervalTicks() {
        return this.intervalTicks;
    }

    public String toString() {
        return "ClassicSchedule{" + (this.delayTicks ? "delay-ticks=" + this.delay : "delay=" + Utils.printTime(this.delay)) + (this.intervalTicks ? ", interval-ticks=" + this.interval : ", interval=" + Utils.printTime(this.interval)) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements ResettableBuilder<ClassicSchedule, Builder> {
        private long delay = 0L;
        private boolean delayTicks = false;
        private long interval = 0L;
        private boolean intervalTicks = false;

        public Builder from(ClassicSchedule value) {
            this.delay = value.getDelay();
            this.delayTicks = value.isDelayTicks();
            this.interval = value.getInterval();
            this.intervalTicks = value.isIntervalTicks();
            return this;
        }

        public Builder reset() {
            this.delay = 0L;
            this.delayTicks = false;
            this.interval = 0L;
            this.intervalTicks = false;
            return this;
        }

        private Builder setDelay(long delay, boolean delayTicks) {
            this.delay = delay;
            this.delayTicks = delayTicks;
            return this;
        }

        public Builder delay(long delay) {
            return this.setDelay(delay, false);
        }

        public Builder delay(long delay, TimeUnit unit) throws IllegalArgumentException {
            return this.delay(unit.toMillis(delay));
        }

        public Builder delayTicks(long delay) {
            return this.setDelay(delay, true);
        }

        private Builder setInterval(long interval, boolean intervalTicks) {
            this.interval = interval;
            this.intervalTicks = intervalTicks;
            return this;
        }

        public Builder interval(long interval) {
            return this.setInterval(interval, false);
        }

        public Builder interval(long interval, TimeUnit unit) throws IllegalArgumentException {
            return this.interval(unit.toMillis(interval));
        }

        public Builder intervalTicks(long interval) {
            return this.setInterval(interval, true);
        }

        public ClassicSchedule build() throws IllegalArgumentException {
            Preconditions.checkArgument((this.delay >= 0L ? 1 : 0) != 0, (Object)("Delay cannot be negative. | Delay:[" + this.delay + "]"));
            Preconditions.checkArgument((this.interval >= 0L ? 1 : 0) != 0, (Object)("Interval cannot be negative. | Interval:[" + this.interval + "]"));
            return new ClassicSchedule(this.delay, this.delayTicks, this.interval, this.intervalTicks);
        }
    }
}

