/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicterminal.init;

import ftblag.thaumicterminal.ThaumicTerminal;
import ftblag.thaumicterminal.item.BaseItem;
import ftblag.thaumicterminal.item.ItemPart;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

public class ModItems {
    private static HashMap<Class<? extends BaseItem>, BaseItem> modItems = new HashMap();

    public static <T extends BaseItem> T getInstance(Class<T> clazz) {
        return (T)((Object)((BaseItem)((Object)clazz.cast((Object)modItems.get(clazz)))));
    }

    public static void initItems() {
        ModItems.addItem(ItemPart.class);
    }

    private static void addItem(Class<? extends BaseItem> itemClass) {
        try {
            BaseItem item = itemClass.newInstance();
            modItems.put(itemClass, item);
            item.setInstance(item);
        }
        catch (Exception e) {
            ThaumicTerminal.logger.fatal("Could not add item " + itemClass.getName(), (Throwable)e);
        }
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        for (BaseItem item : modItems.values()) {
            item.registerItem(registry);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void initRenders() {
        for (BaseItem item : modItems.values()) {
            item.registerItemRender();
        }
    }

    public static void postInitItems() {
        for (BaseItem item : modItems.values()) {
            item.postInit();
        }
    }
}

