/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Check32;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.ItemStackTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.builder.BuilderConfiguration;
import mcjty.rftools.blocks.builder.BuilderTileEntity;
import mcjty.rftools.items.GenericRFToolsItem;
import mcjty.rftools.items.builder.ShapeCardType;
import mcjty.rftools.setup.GuiProxy;
import mcjty.rftools.shapes.IFormula;
import mcjty.rftools.shapes.ScanDataManager;
import mcjty.rftools.shapes.Shape;
import mcjty.rftools.shapes.ShapeDeprecated;
import mcjty.rftools.shapes.ShapeModifier;
import mcjty.rftools.shapes.StatePalette;
import mcjty.rftools.varia.RLE;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;

public class ShapeCardItem
extends GenericRFToolsItem
implements INBTPreservingIngredient {
    public static final int MAXIMUM_COUNT = 50000000;
    public static final int MODE_NONE = 0;
    public static final int MODE_CORNER1 = 1;
    public static final int MODE_CORNER2 = 2;

    public ShapeCardItem() {
        super("shape_card");
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (ShapeCardType type : ShapeCardType.values()) {
            ModelResourceLocation modelResourceLocation = type.getModelResourceLocation();
            if (modelResourceLocation == null) continue;
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)type.getDamage(), (ModelResourceLocation)modelResourceLocation);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) return EnumActionResult.SUCCESS;
        int mode = ShapeCardItem.getMode(stack);
        if (mode == 0) {
            if (!player.func_70093_af()) return EnumActionResult.SUCCESS;
            if (world.func_175625_s(pos) instanceof BuilderTileEntity) {
                ShapeCardItem.setCurrentBlock(stack, new GlobalCoordinate(pos, world.field_73011_w.getDimension()));
                Logging.message((EntityPlayer)player, (String)(TextFormatting.GREEN + "Now select the first corner"));
                ShapeCardItem.setMode(stack, 1);
                ShapeCardItem.setCorner1(stack, null);
                return EnumActionResult.SUCCESS;
            } else {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "You can only do this on a builder!"));
            }
            return EnumActionResult.SUCCESS;
        } else if (mode == 1) {
            GlobalCoordinate currentBlock = ShapeCardItem.getCurrentBlock(stack);
            if (currentBlock.getDimension() != world.field_73011_w.getDimension()) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "The Builder is in another dimension!"));
                return EnumActionResult.SUCCESS;
            } else if (currentBlock.getCoordinate().equals((Object)pos)) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Cleared area selection mode!"));
                ShapeCardItem.setMode(stack, 0);
                return EnumActionResult.SUCCESS;
            } else {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.GREEN + "Now select the second corner"));
                ShapeCardItem.setMode(stack, 2);
                ShapeCardItem.setCorner1(stack, pos);
            }
            return EnumActionResult.SUCCESS;
        } else {
            GlobalCoordinate currentBlock = ShapeCardItem.getCurrentBlock(stack);
            if (currentBlock.getDimension() != world.field_73011_w.getDimension()) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "The Builder is in another dimension!"));
                return EnumActionResult.SUCCESS;
            } else if (currentBlock.getCoordinate().equals((Object)pos)) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Cleared area selection mode!"));
                ShapeCardItem.setMode(stack, 0);
                return EnumActionResult.SUCCESS;
            } else {
                NBTTagCompound tag = ShapeCardItem.getCompound(stack);
                BlockPos c1 = ShapeCardItem.getCorner1(stack);
                if (c1 == null) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Cleared area selection mode!"));
                    ShapeCardItem.setMode(stack, 0);
                    return EnumActionResult.SUCCESS;
                } else {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.GREEN + "New settings copied to the shape card!"));
                    BlockPos center = new BlockPos((int)Math.ceil((float)(c1.func_177958_n() + pos.func_177958_n()) / 2.0f), (int)Math.ceil((float)(c1.func_177956_o() + pos.func_177956_o()) / 2.0f), (int)Math.ceil((float)(c1.func_177952_p() + pos.func_177952_p()) / 2.0f));
                    ShapeCardItem.setDimension(stack, Math.abs(c1.func_177958_n() - pos.func_177958_n()) + 1, Math.abs(c1.func_177956_o() - pos.func_177956_o()) + 1, Math.abs(c1.func_177952_p() - pos.func_177952_p()) + 1);
                    ShapeCardItem.setOffset(stack, center.func_177958_n() - currentBlock.getCoordinate().func_177958_n(), center.func_177956_o() - currentBlock.getCoordinate().func_177956_o(), center.func_177952_p() - currentBlock.getCoordinate().func_177952_p());
                    ShapeCardItem.setMode(stack, 0);
                    ShapeCardItem.setCorner1(stack, null);
                    ShapeCardItem.setShape(stack, Shape.SHAPE_BOX, true);
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public static void setData(NBTTagCompound tagCompound, int scanID) {
        tagCompound.func_74768_a("scanid", scanID);
    }

    public static void setModifier(NBTTagCompound tag, ShapeModifier modifier) {
        tag.func_74778_a("mod_op", modifier.getOperation().getCode());
        tag.func_74757_a("mod_flipy", modifier.isFlipY());
        tag.func_74778_a("mod_rot", modifier.getRotation().getCode());
    }

    public static void setGhostMaterial(NBTTagCompound tag, ItemStack materialGhost) {
        if (materialGhost.func_190926_b()) {
            tag.func_82580_o("ghost_block");
            tag.func_82580_o("ghost_meta");
        } else {
            Block block = Block.func_149634_a((Item)materialGhost.func_77973_b());
            if (block == null) {
                tag.func_82580_o("ghost_block");
                tag.func_82580_o("ghost_meta");
            } else {
                tag.func_74778_a("ghost_block", block.getRegistryName().toString());
                tag.func_74768_a("ghost_meta", materialGhost.func_77960_j());
            }
        }
    }

    public static void setChildren(ItemStack itemStack, NBTTagList list) {
        NBTTagCompound tagCompound = ShapeCardItem.getCompound(itemStack);
        tagCompound.func_74782_a("children", (NBTBase)list);
    }

    public static void setDimension(ItemStack itemStack, int x, int y, int z) {
        NBTTagCompound tagCompound = ShapeCardItem.getCompound(itemStack);
        if (tagCompound.func_74762_e("dimX") == x && tagCompound.func_74762_e("dimY") == y && tagCompound.func_74762_e("dimZ") == z) {
            return;
        }
        tagCompound.func_74768_a("dimX", x);
        tagCompound.func_74768_a("dimY", y);
        tagCompound.func_74768_a("dimZ", z);
    }

    public static void setOffset(ItemStack itemStack, int x, int y, int z) {
        NBTTagCompound tagCompound = ShapeCardItem.getCompound(itemStack);
        if (tagCompound.func_74762_e("offsetX") == x && tagCompound.func_74762_e("offsetY") == y && tagCompound.func_74762_e("offsetZ") == z) {
            return;
        }
        tagCompound.func_74768_a("offsetX", x);
        tagCompound.func_74768_a("offsetY", y);
        tagCompound.func_74768_a("offsetZ", z);
    }

    private static NBTTagCompound getCompound(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    public static void setCorner1(ItemStack itemStack, BlockPos corner) {
        NBTTagCompound tagCompound = ShapeCardItem.getCompound(itemStack);
        if (corner == null) {
            tagCompound.func_82580_o("corner1x");
            tagCompound.func_82580_o("corner1y");
            tagCompound.func_82580_o("corner1z");
        } else {
            tagCompound.func_74768_a("corner1x", corner.func_177958_n());
            tagCompound.func_74768_a("corner1y", corner.func_177956_o());
            tagCompound.func_74768_a("corner1z", corner.func_177952_p());
        }
    }

    public static BlockPos getCorner1(ItemStack stack1) {
        NBTTagCompound tagCompound = stack1.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        if (!tagCompound.func_74764_b("corner1x")) {
            return null;
        }
        return new BlockPos(tagCompound.func_74762_e("corner1x"), tagCompound.func_74762_e("corner1y"), tagCompound.func_74762_e("corner1z"));
    }

    public static int getMode(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            return tagCompound.func_74762_e("mode");
        }
        return 0;
    }

    public static void setMode(ItemStack itemStack, int mode) {
        NBTTagCompound tagCompound = ShapeCardItem.getCompound(itemStack);
        if (tagCompound.func_74762_e("mode") == mode) {
            return;
        }
        tagCompound.func_74768_a("mode", mode);
    }

    public static void setCurrentBlock(ItemStack itemStack, GlobalCoordinate c) {
        NBTTagCompound tagCompound = ShapeCardItem.getCompound(itemStack);
        if (c == null) {
            tagCompound.func_82580_o("selectedX");
            tagCompound.func_82580_o("selectedY");
            tagCompound.func_82580_o("selectedZ");
            tagCompound.func_82580_o("selectedDim");
        } else {
            tagCompound.func_74768_a("selectedX", c.getCoordinate().func_177958_n());
            tagCompound.func_74768_a("selectedY", c.getCoordinate().func_177956_o());
            tagCompound.func_74768_a("selectedZ", c.getCoordinate().func_177952_p());
            tagCompound.func_74768_a("selectedDim", c.getDimension());
        }
    }

    public static GlobalCoordinate getCurrentBlock(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("selectedX")) {
            int x = tagCompound.func_74762_e("selectedX");
            int y = tagCompound.func_74762_e("selectedY");
            int z = tagCompound.func_74762_e("selectedZ");
            int dim = tagCompound.func_74762_e("selectedDim");
            return new GlobalCoordinate(new BlockPos(x, y, z), dim);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        NBTTagCompound card;
        super.func_77624_a(itemStack, player, list, whatIsThis);
        ShapeCardType type = ShapeCardType.fromDamage(itemStack.func_77952_i());
        if (!BuilderConfiguration.shapeCardAllowed.get()) {
            list.add(TextFormatting.RED + "Disabled in config!");
        } else if (type != ShapeCardType.CARD_SHAPE) {
            if (!BuilderConfiguration.quarryAllowed.get()) {
                list.add(TextFormatting.RED + "Disabled in config!");
            } else if (type.isQuarry() && type.isClearing() && !BuilderConfiguration.clearingQuarryAllowed.get()) {
                list.add(TextFormatting.RED + "Disabled in config!");
            }
        }
        Shape shape = ShapeCardItem.getShape(itemStack);
        boolean issolid = ShapeCardItem.isSolid(itemStack);
        list.add(TextFormatting.GREEN + "Shape " + shape.getDescription() + " (" + (issolid ? "Solid" : "Hollow") + ")");
        list.add(TextFormatting.GREEN + "Dimension " + BlockPosTools.toString((BlockPos)ShapeCardItem.getDimension(itemStack)));
        list.add(TextFormatting.GREEN + "Offset " + BlockPosTools.toString((BlockPos)ShapeCardItem.getOffset(itemStack)));
        if (shape.isComposition()) {
            card = itemStack.func_77978_p();
            NBTTagList children = card.func_150295_c("children", 10);
            list.add(TextFormatting.DARK_GREEN + "Formulas: " + children.func_74745_c());
        }
        if (shape.isScan()) {
            card = itemStack.func_77978_p();
            int scanid = card.func_74762_e("scanid");
            list.add(TextFormatting.DARK_GREEN + "Scan id: " + scanid);
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.YELLOW + "Sneak right click on builder to start mark mode");
            list.add(TextFormatting.YELLOW + "Then right click to mark two corners of wanted area");
            type.addInformation(list);
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public static boolean isNormalShapeCard(ItemStack stack) {
        int damage = stack.func_77952_i();
        return damage == ShapeCardType.CARD_SHAPE.getDamage() || damage == ShapeCardType.CARD_PUMP_LIQUID.getDamage();
    }

    private static void addBlocks(Set<Block> blocks, Block block, boolean oredict) {
        blocks.add(block);
        if (oredict) {
            int[] iDs;
            for (int id : iDs = OreDictionary.getOreIDs((ItemStack)new ItemStack(block))) {
                String oreName = OreDictionary.getOreName((int)id);
                List ores = ItemStackTools.getOres((String)oreName);
                for (ItemStack ore : ores) {
                    if (!(ore.func_77973_b() instanceof ItemBlock)) continue;
                    blocks.add(((ItemBlock)ore.func_77973_b()).func_179223_d());
                }
            }
        }
    }

    public static Set<Block> getVoidedBlocks(ItemStack stack) {
        HashSet<Block> blocks = new HashSet<Block>();
        boolean oredict = ShapeCardItem.isOreDictionary(stack);
        if (ShapeCardItem.isVoiding(stack, "stone")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150348_b, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "cobble")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150347_e, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "dirt")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150346_d, oredict);
            ShapeCardItem.addBlocks(blocks, (Block)Blocks.field_150349_c, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "sand")) {
            ShapeCardItem.addBlocks(blocks, (Block)Blocks.field_150354_m, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "gravel")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150351_n, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "netherrack")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150424_aL, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "endstone")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150377_bs, oredict);
        }
        return blocks;
    }

    public static boolean isOreDictionary(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        return tagCompound.func_74767_n("oredict");
    }

    public static boolean isVoiding(ItemStack stack, String material) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        return tagCompound.func_74767_n("void" + material);
    }

    public static Shape getShape(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        return ShapeCardItem.getShape(tagCompound);
    }

    public static Shape getShape(NBTTagCompound tagCompound) {
        Shape shape;
        if (tagCompound == null) {
            return Shape.SHAPE_BOX;
        }
        if (!tagCompound.func_74764_b("shape") && !tagCompound.func_74764_b("shapenew")) {
            return Shape.SHAPE_BOX;
        }
        if (tagCompound.func_74764_b("shapenew")) {
            String sn = tagCompound.func_74779_i("shapenew");
            shape = Shape.getShape(sn);
        } else {
            int shapedeprecated = tagCompound.func_74762_e("shape");
            ShapeDeprecated sd = ShapeDeprecated.getShape(shapedeprecated);
            shape = sd.getNewshape();
        }
        if (shape == null) {
            return Shape.SHAPE_BOX;
        }
        return shape;
    }

    public static boolean isSolid(ItemStack stack) {
        if (stack.func_190926_b()) {
            return true;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        return ShapeCardItem.isSolid(tagCompound);
    }

    public static boolean isSolid(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return true;
        }
        if (!tagCompound.func_74764_b("shape") && !tagCompound.func_74764_b("shapenew")) {
            return true;
        }
        if (tagCompound.func_74764_b("shapenew")) {
            return tagCompound.func_74767_n("solid");
        }
        int shapedeprecated = tagCompound.func_74762_e("shape");
        ShapeDeprecated sd = ShapeDeprecated.getShape(shapedeprecated);
        return sd.isSolid();
    }

    public static IFormula createCorrectFormula(NBTTagCompound tagCompound) {
        Shape shape = ShapeCardItem.getShape(tagCompound);
        boolean solid = ShapeCardItem.isSolid(tagCompound);
        IFormula formula = shape.getFormulaFactory().get();
        return formula.correctFormula(solid);
    }

    public static int getScanId(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        NBTTagCompound tagCompound = ShapeCardItem.getCompound(stack);
        Shape shape = ShapeCardItem.getShape(tagCompound);
        if (shape != Shape.SHAPE_SCAN) {
            return 0;
        }
        return tagCompound.func_74762_e("scanid");
    }

    public static int getScanIdRecursive(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return ShapeCardItem.getScanIdRecursive(ShapeCardItem.getCompound(stack));
    }

    private static int getScanIdRecursive(NBTTagCompound tagCompound) {
        Shape shape = ShapeCardItem.getShape(tagCompound);
        if (tagCompound.func_74764_b("scanid") && shape == Shape.SHAPE_SCAN) {
            return tagCompound.func_74762_e("scanid");
        }
        if (shape == Shape.SHAPE_COMPOSITION) {
            NBTTagList children = tagCompound.func_150295_c("children", 10);
            for (int i = 0; i < children.func_74745_c(); ++i) {
                NBTTagCompound childTag = children.func_150305_b(i);
                int id = ShapeCardItem.getScanIdRecursive(childTag);
                if (id == 0) continue;
                return id;
            }
        }
        return 0;
    }

    public static int getFormulaCheckClient(ItemStack stack) {
        Check32 crc = new Check32();
        ShapeCardItem.getFormulaCheckClient(stack, crc);
        return crc.get();
    }

    public static void getFormulaCheckClient(ItemStack stack, Check32 crc) {
        Shape shape = ShapeCardItem.getShape(stack);
        IFormula formula = shape.getFormulaFactory().get();
        formula.getCheckSumClient(stack.func_77978_p(), crc);
    }

    public static void getLocalChecksum(NBTTagCompound tagCompound, Check32 crc) {
        if (tagCompound == null) {
            return;
        }
        crc.add(ShapeCardItem.getShape(tagCompound).ordinal());
        BlockPos dim = ShapeCardItem.getDimension(tagCompound);
        crc.add(dim.func_177958_n());
        crc.add(dim.func_177956_o());
        crc.add(dim.func_177952_p());
        crc.add(ShapeCardItem.isSolid(tagCompound) ? 1 : 0);
    }

    public static void setShape(ItemStack stack, Shape shape, boolean solid) {
        NBTTagCompound tagCompound = ShapeCardItem.getCompound(stack);
        if (ShapeCardItem.isSolid(tagCompound) == solid && ShapeCardItem.getShape(tagCompound).equals((Object)shape)) {
            return;
        }
        tagCompound.func_74778_a("shapenew", shape.getDescription());
        tagCompound.func_74757_a("solid", solid);
    }

    public static BlockPos getDimension(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        return ShapeCardItem.getDimension(tagCompound);
    }

    public static BlockPos getDimension(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return new BlockPos(5, 5, 5);
        }
        if (!tagCompound.func_74764_b("dimX")) {
            return new BlockPos(5, 5, 5);
        }
        int dimX = tagCompound.func_74762_e("dimX");
        int dimY = tagCompound.func_74762_e("dimY");
        int dimZ = tagCompound.func_74762_e("dimZ");
        return new BlockPos(dimX, ShapeCardItem.clampDimension(dimY, 256), dimZ);
    }

    public static BlockPos getClampedDimension(ItemStack stack, int maximum) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        return ShapeCardItem.getClampedDimension(tagCompound, maximum);
    }

    public static BlockPos getClampedDimension(NBTTagCompound tagCompound, int maximum) {
        if (tagCompound == null) {
            return new BlockPos(5, 5, 5);
        }
        int dimX = tagCompound.func_74762_e("dimX");
        int dimY = tagCompound.func_74762_e("dimY");
        int dimZ = tagCompound.func_74762_e("dimZ");
        return new BlockPos(ShapeCardItem.clampDimension(dimX, maximum), ShapeCardItem.clampDimension(dimY, maximum), ShapeCardItem.clampDimension(dimZ, maximum));
    }

    private static int clampDimension(int o, int maximum) {
        if (o > maximum) {
            o = maximum;
        } else if (o < 0) {
            o = 0;
        }
        return o;
    }

    public static BlockPos getOffset(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return new BlockPos(0, 0, 0);
        }
        int offsetX = tagCompound.func_74762_e("offsetX");
        int offsetY = tagCompound.func_74762_e("offsetY");
        int offsetZ = tagCompound.func_74762_e("offsetZ");
        return new BlockPos(offsetX, offsetY, offsetZ);
    }

    public static BlockPos getClampedOffset(ItemStack stack, int maximum) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        return ShapeCardItem.getClampedOffset(tagCompound, maximum);
    }

    public static BlockPos getClampedOffset(NBTTagCompound tagCompound, int maximum) {
        if (tagCompound == null) {
            return new BlockPos(0, 0, 0);
        }
        int offsetX = tagCompound.func_74762_e("offsetX");
        int offsetY = tagCompound.func_74762_e("offsetY");
        int offsetZ = tagCompound.func_74762_e("offsetZ");
        return new BlockPos(ShapeCardItem.clampOffset(offsetX, maximum), ShapeCardItem.clampOffset(offsetY, maximum), ShapeCardItem.clampOffset(offsetZ, maximum));
    }

    private static int clampOffset(int o, int maximum) {
        if (o < -maximum) {
            o = -maximum;
        } else if (o > maximum) {
            o = maximum;
        }
        return o;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            player.openGui((Object)RFTools.instance, GuiProxy.GUI_SHAPECARD, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static BlockPos getMinCorner(BlockPos thisCoord, BlockPos dimension, BlockPos offset) {
        int xCoord = thisCoord.func_177958_n();
        int yCoord = thisCoord.func_177956_o();
        int zCoord = thisCoord.func_177952_p();
        int dx = dimension.func_177958_n();
        int dy = dimension.func_177956_o();
        int dz = dimension.func_177952_p();
        return new BlockPos(xCoord - dx / 2 + offset.func_177958_n(), yCoord - dy / 2 + offset.func_177956_o(), zCoord - dz / 2 + offset.func_177952_p());
    }

    public static BlockPos getMaxCorner(BlockPos thisCoord, BlockPos dimension, BlockPos offset) {
        int dx = dimension.func_177958_n();
        int dy = dimension.func_177956_o();
        int dz = dimension.func_177952_p();
        BlockPos minCorner = ShapeCardItem.getMinCorner(thisCoord, dimension, offset);
        return new BlockPos(minCorner.func_177958_n() + dx, minCorner.func_177956_o() + dy, minCorner.func_177952_p() + dz);
    }

    public static boolean xInChunk(int x, ChunkPos chunk) {
        if (chunk == null) {
            return true;
        }
        return chunk.field_77276_a == x >> 4;
    }

    public static boolean zInChunk(int z, ChunkPos chunk) {
        if (chunk == null) {
            return true;
        }
        return chunk.field_77275_b == z >> 4;
    }

    private static void placeBlockIfPossible(World worldObj, Map<BlockPos, IBlockState> blocks, int maxSize, int x, int y, int z, IBlockState state, boolean forquarry) {
        BlockPos c = new BlockPos(x, y, z);
        if (worldObj == null) {
            blocks.put(c, state);
            return;
        }
        if (forquarry) {
            if (worldObj.func_175623_d(c)) {
                return;
            }
            blocks.put(c, state);
        } else if (BuilderTileEntity.isEmptyOrReplacable(worldObj, c) && blocks.size() < maxSize) {
            blocks.put(c, state);
        }
    }

    public static int getRenderPositions(ItemStack stack, boolean solid, RLE positions, StatePalette statePalette, IFormula formula, int oy) {
        BlockPos dimension = ShapeCardItem.getDimension(stack);
        BlockPos clamped = new BlockPos(Math.min(dimension.func_177958_n(), 512), Math.min(dimension.func_177956_o(), 256), Math.min(dimension.func_177952_p(), 512));
        int dx = clamped.func_177958_n();
        int dy = clamped.func_177956_o();
        int dz = clamped.func_177952_p();
        int cnt = 0;
        int y = oy - dy / 2;
        for (int ox = 0; ox < dx; ++ox) {
            int x = ox - dx / 2;
            for (int oz = 0; oz < dz; ++oz) {
                int z = oz - dz / 2;
                int v = 255;
                if (formula.isInside(x, y, z)) {
                    ++cnt;
                    IBlockState lastState = formula.getLastState();
                    if (solid) {
                        if (ox == 0 || ox == dx - 1 || oy == 0 || oy == dy - 1 || oz == 0 || oz == dz - 1) {
                            v = statePalette.alloc(lastState, -1) + 1;
                        } else if (formula.isVisible(x, y, z)) {
                            v = statePalette.alloc(lastState, -1) + 1;
                        }
                    } else {
                        v = statePalette.alloc(lastState, -1) + 1;
                    }
                }
                positions.add(v);
            }
        }
        return cnt;
    }

    public static int getDataPositions(ItemStack stack, Shape shape, boolean solid, RLE positions, StatePalette statePalette) {
        BlockPos dimension = ShapeCardItem.getDimension(stack);
        BlockPos clamped = new BlockPos(Math.min(dimension.func_177958_n(), 512), Math.min(dimension.func_177956_o(), 256), Math.min(dimension.func_177952_p(), 512));
        IFormula formula = shape.getFormulaFactory().get();
        int dx = clamped.func_177958_n();
        int dy = clamped.func_177956_o();
        int dz = clamped.func_177952_p();
        formula = formula.correctFormula(solid);
        formula.setup(new BlockPos(0, 0, 0), clamped, new BlockPos(0, 0, 0), stack != null ? stack.func_77978_p() : null);
        int cnt = 0;
        for (int ox = 0; ox < dx; ++ox) {
            int x = ox - dx / 2;
            for (int oz = 0; oz < dz; ++oz) {
                int z = oz - dz / 2;
                for (int oy = 0; oy < dy; ++oy) {
                    int y = oy - dy / 2;
                    int v = 255;
                    if (formula.isInside(x, y, z)) {
                        ++cnt;
                        IBlockState lastState = formula.getLastState();
                        if (lastState == null) {
                            lastState = Blocks.field_150348_b.func_176223_P();
                        }
                        v = statePalette.alloc(lastState, 0) + 1;
                    }
                    positions.add(v);
                }
            }
        }
        return cnt;
    }

    public static void composeFormula(ItemStack shapeCard, IFormula formula, World worldObj, BlockPos thisCoord, BlockPos dimension, BlockPos offset, Map<BlockPos, IBlockState> blocks, int maxSize, boolean solid, boolean forquarry, ChunkPos chunk) {
        int xCoord = thisCoord.func_177958_n();
        int yCoord = thisCoord.func_177956_o();
        int zCoord = thisCoord.func_177952_p();
        int dx = dimension.func_177958_n();
        int dy = dimension.func_177956_o();
        int dz = dimension.func_177952_p();
        BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.func_177958_n(), yCoord - dy / 2 + offset.func_177956_o(), zCoord - dz / 2 + offset.func_177952_p());
        formula = formula.correctFormula(solid);
        formula.setup(thisCoord, dimension, offset, shapeCard != null ? shapeCard.func_77978_p() : null);
        for (int ox = 0; ox < dx; ++ox) {
            int x = tl.func_177958_n() + ox;
            if (!ShapeCardItem.xInChunk(x, chunk)) continue;
            for (int oz = 0; oz < dz; ++oz) {
                int z = tl.func_177952_p() + oz;
                if (!ShapeCardItem.zInChunk(z, chunk)) continue;
                for (int oy = 0; oy < dy; ++oy) {
                    int y = tl.func_177956_o() + oy;
                    if (!formula.isInside(x, y, z)) continue;
                    ShapeCardItem.placeBlockIfPossible(worldObj, blocks, maxSize, x, y, z, formula.getLastState(), forquarry);
                }
            }
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        if (itemStack.func_77952_i() == 0) {
            return super.func_77667_c(itemStack);
        }
        return super.func_77667_c(itemStack) + itemStack.func_77952_i();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (ShapeCardType type : ShapeCardType.values()) {
                int damage = type.getDamage();
                if (damage < 0) continue;
                items.add((Object)new ItemStack((Item)this, 1, damage));
            }
        }
    }

    private static boolean validFile(EntityPlayer player, String filename) {
        if (filename.contains("\\") || filename.contains("/") || filename.contains(":")) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid filename '" + filename + "'! Cannot be a path!"), false);
            return false;
        }
        return true;
    }

    public static void save(EntityPlayer player, ItemStack card, String filename) {
        if (!ShapeCardItem.validFile(player, filename)) {
            return;
        }
        Shape shape = ShapeCardItem.getShape(card);
        boolean solid = ShapeCardItem.isSolid(card);
        BlockPos offset = ShapeCardItem.getOffset(card);
        BlockPos dimension = ShapeCardItem.getDimension(card);
        RLE positions = new RLE();
        StatePalette statePalette = new StatePalette();
        int cnt = ShapeCardItem.getDataPositions(card, shape, solid, positions, statePalette);
        byte[] data = positions.getData();
        File dataDir = new File("rftoolsscans");
        dataDir.mkdirs();
        File file = new File(dataDir, filename);
        try (PrintWriter writer = new PrintWriter(new FileOutputStream(file));){
            writer.println("SHAPE");
            writer.println("DIM:" + dimension.func_177958_n() + "," + dimension.func_177956_o() + "," + dimension.func_177952_p());
            writer.println("OFF:" + offset.func_177958_n() + "," + offset.func_177956_o() + "," + offset.func_177952_p());
            for (IBlockState state : statePalette.getPalette()) {
                String r = state.func_177230_c().getRegistryName().toString();
                writer.println(r + "@" + state.func_177230_c().func_176201_c(state));
            }
            writer.println("DATA");
            byte[] encoded = Base64.getEncoder().encode(data);
            writer.write(new String(encoded));
        }
        catch (FileNotFoundException e) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Cannot write to file '" + filename + "'!"), false);
            return;
        }
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Saved shape to file '" + file.getPath() + "'"), false);
    }

    public static void load(EntityPlayer player, ItemStack card, String filename) {
        if (!ShapeCardItem.validFile(player, filename)) {
            return;
        }
        Shape shape = ShapeCardItem.getShape(card);
        if (shape != Shape.SHAPE_SCAN) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "To load a file into this card you need a linked 'scan' type card!"), false);
            return;
        }
        NBTTagCompound compound = ShapeCardItem.getCompound(card);
        int scanId = compound.func_74762_e("scanid");
        if (scanId == 0) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "This card is not linked to scan data!"), false);
            return;
        }
        File dataDir = new File("rftoolsscans");
        dataDir.mkdirs();
        File file = new File(dataDir, filename);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String s = reader.readLine();
            if (!"SHAPE".equals(s)) {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "This does not appear to be a valid shapecard file!"), false);
                return;
            }
            s = reader.readLine();
            if (!s.startsWith("DIM:")) {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "This does not appear to be a valid shapecard file!"), false);
                return;
            }
            BlockPos dim = ShapeCardItem.parse(s.substring(4));
            s = reader.readLine();
            if (!s.startsWith("OFF:")) {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "This does not appear to be a valid shapecard file!"), false);
                return;
            }
            BlockPos off = ShapeCardItem.parse(s.substring(4));
            s = reader.readLine();
            StatePalette statePalette = new StatePalette();
            while (!"DATA".equals(s)) {
                String[] split = StringUtils.split((String)s, (char)'@');
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0]));
                int meta = Integer.parseInt(split[1]);
                if (block == null) {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Could not find block '" + split[0] + "'!"), false);
                    block = Blocks.field_150348_b;
                    meta = 0;
                }
                statePalette.add(block.func_176203_a(meta));
                s = reader.readLine();
            }
            s = reader.readLine();
            byte[] decoded = Base64.getDecoder().decode(s.getBytes());
            ShapeCardItem.setDataFromFile(scanId, card, dim, off, decoded, statePalette);
        }
        catch (FileNotFoundException e) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Cannot read from file '" + filename + "'!"), false);
            return;
        }
        catch (IOException e) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Cannot read from file '" + filename + "'!"), false);
            return;
        }
        catch (NullPointerException e) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "File '" + filename + "' is too short!"), false);
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "File '" + filename + "' contains invalid entries!"), false);
            return;
        }
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Loaded shape from file '" + file.getPath() + "'"), false);
    }

    private static void setDataFromFile(int scanId, ItemStack card, BlockPos dimension, BlockPos offset, byte[] data, StatePalette palette) {
        ScanDataManager scans = ScanDataManager.getScans();
        scans.getOrCreateScan(scanId).setData(data, palette.getPalette(), dimension, offset);
        scans.save(scanId);
        ShapeCardItem.setDimension(card, dimension.func_177958_n(), dimension.func_177956_o(), dimension.func_177952_p());
        ShapeCardItem.setOffset(card, offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
        ShapeCardItem.setShape(card, Shape.SHAPE_SCAN, true);
    }

    private static BlockPos parse(String s) {
        String[] split = StringUtils.split((String)s, (char)',');
        return new BlockPos(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
    }
}

