/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.infos;

import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.infos.InfoEntry;
import pregenerator.impl.storage.PregenTask;

public class TaskEntry
extends InfoEntry {
    int type;

    public TaskEntry() {
        this.register();
    }

    @Override
    public String getName() {
        return "Task Type";
    }

    @Override
    public void write(IWriteableBuffer buf) {
        PregenTask task = this.getProcessor().getTask();
        buf.writeByte(task != null ? task.getType() : 0);
    }

    @Override
    public void read(IReadableBuffer buf) {
        this.type = buf.readByte();
    }

    @Override
    public int currentValue() {
        return 0;
    }

    @Override
    public int maxValue() {
        return 0;
    }

    @Override
    public void render(int x, int y, float progress, int width, IRenderHelper helper) {
        int wid = width - 25;
        helper.renderText(x - wid, y, width, "Task Type: " + this.getType());
    }

    private String getType() {
        switch (this.type) {
            case 1: {
                return "Circle Generation";
            }
            case 2: {
                return "Mass Square Generation";
            }
            case 3: {
                return "Mass Circle Generation";
            }
            case 4: {
                return "Square Extension Generation";
            }
            case 5: {
                return "Circle Extension Generation";
            }
            case 6: {
                return "Small Benchmark Task";
            }
            case 7: {
                return "Big Benchmark Task";
            }
        }
        return "Square Generation";
    }
}

