/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop.command;

import com.carrot.carrotshop.CarrotShop;
import com.carrot.carrotshop.Lang;
import com.carrot.carrotshop.ShopsData;
import com.carrot.carrotshop.command.importObjects.AdminShop;
import com.carrot.carrotshop.shop.Shop;
import com.carrot.carrotshop.shop.iBuy;
import com.carrot.carrotshop.shop.iSell;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.data.manipulator.mutable.tileentity.SignData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.text.Text;

public class ShopImportExecutor
implements CommandExecutor {
    File defaultConfigDir;

    public ShopImportExecutor(File defaultConfigDir) {
        this.defaultConfigDir = defaultConfigDir;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Optional plugin = args.getOne("plugin");
        if (!plugin.isPresent()) {
            src.sendMessage((Text)Text.of((String)Lang.CMD_IMPORT_USAGE));
            src.sendMessage((Text)Text.of((String)" - adminshop"));
            return CommandResult.empty();
        }
        if (((String)plugin.get()).equalsIgnoreCase("adminshop")) {
            return this.importAdminShop(src, new File(this.defaultConfigDir, "adminshop/data/shops.conf"));
        }
        src.sendMessage((Text)Text.of((String)Lang.CMD_IMPORT_USAGE));
        src.sendMessage((Text)Text.of((String)" - adminshop"));
        return CommandResult.empty();
    }

    private CommandResult importAdminShop(CommandSource src, File file) {
        if (!file.exists() || !file.canRead()) {
            src.sendMessage((Text)Text.of((String)Lang.CMD_IMPORT_ADMINSHOP_ERROR_FILE));
            return CommandResult.empty();
        }
        int count = 0;
        try {
            ConfigurationNode shopsNode = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(file)).build().load();
            for (ConfigurationNode shopNode : shopsNode.getNode(new Object[]{"shops"}).getChildrenMap().values()) {
                try {
                    Optional data;
                    AdminShop adminshop = (AdminShop)shopNode.getValue(TypeToken.of(AdminShop.class));
                    Optional sign = adminshop.signLocation.getTileEntity();
                    if (!sign.isPresent() || !((TileEntity)sign.get()).supports(SignData.class) || !(data = ((TileEntity)sign.get()).get(SignData.class)).isPresent()) continue;
                    SignData signData = (SignData)data.get();
                    if (adminshop.buyShop) {
                        signData.set((BaseValue)signData.lines().set(0, (Object)Text.of((String)"[iSell]")));
                    } else {
                        signData.set((BaseValue)signData.lines().set(0, (Object)Text.of((String)"[iBuy]")));
                    }
                    String itemName = Shop.getItemName(adminshop.item.createStack()).toPlain();
                    if (itemName.length() > 15) {
                        signData.set((BaseValue)signData.lines().set(1, (Object)Text.of((Object[])new Object[]{itemName.substring(12), "..."})));
                    } else {
                        signData.set((BaseValue)signData.lines().set(1, (Object)Text.of((String)itemName)));
                    }
                    signData.set((BaseValue)signData.lines().set(2, (Object)Text.of((Object[])new Object[]{"x", adminshop.item.getCount()})));
                    signData.set((BaseValue)signData.lines().set(3, (Object)Text.EMPTY));
                    if (adminshop.price > 0.0 && CarrotShop.getEcoService() != null) {
                        signData.set((BaseValue)signData.lines().set(3, (Object)Text.of((Object[])new Object[]{ShopsData.getCurrency().format(BigDecimal.valueOf(adminshop.price))})));
                    }
                    ((TileEntity)sign.get()).offer((ValueContainer)signData);
                    Shop shop = adminshop.buyShop ? new iSell(adminshop.signLocation, adminshop.item) : new iBuy(adminshop.signLocation, adminshop.item);
                    Optional<List<Shop>> oldShopList = ShopsData.getShops(shop.getLocation());
                    if (oldShopList.isPresent()) {
                        ArrayList toDelete = new ArrayList();
                        oldShopList.get().forEach(oldShop -> toDelete.add(oldShop));
                        toDelete.forEach(oldShop -> oldShop.destroy(src));
                    }
                    ShopsData.addShop(shop);
                }
                catch (ObjectMappingException e) {
                    src.sendMessage((Text)Text.of((String)Lang.CMD_IMPORT_ADMINSHOP_ERROR_LOAD_ITEM));
                    src.sendMessage((Text)Text.of((String)shopNode.getKey().toString()));
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            src.sendMessage((Text)Text.of((String)Lang.CMD_IMPORT_ADMINSHOP_ERROR_LOAD));
            e.printStackTrace();
        }
        return CommandResult.queryResult((int)count);
    }
}

