/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import info.openmods.calc.parsing.InvalidTokenException;
import info.openmods.calc.parsing.ast.IAstParser;
import info.openmods.calc.parsing.ast.IModifierStateTransition;
import info.openmods.calc.parsing.ast.INodeFactory;
import info.openmods.calc.parsing.ast.IOperator;
import info.openmods.calc.parsing.ast.IOperatorDictionary;
import info.openmods.calc.parsing.ast.IParserState;
import info.openmods.calc.parsing.ast.ISymbolCallStateTransition;
import info.openmods.calc.parsing.ast.NonExpressionException;
import info.openmods.calc.parsing.ast.OperatorArity;
import info.openmods.calc.parsing.ast.UnfinishedExpressionException;
import info.openmods.calc.parsing.ast.UnmatchedBracketsException;
import info.openmods.calc.parsing.token.Token;
import info.openmods.calc.parsing.token.TokenType;
import info.openmods.calc.parsing.token.TokenUtils;
import info.openmods.calc.utils.Stack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class InfixParser<N, O extends IOperator<O>>
implements IAstParser<N> {
    private static final String CALL_OPENING_BRACKET = "(";
    private final IOperatorDictionary<O> operators;
    private INodeFactory<N, O> nodeFactory;

    public InfixParser(IOperatorDictionary<O> operators, INodeFactory<N, O> exprNodeFactory) {
        this.nodeFactory = exprNodeFactory;
        this.operators = operators;
    }

    private static Token next(Iterator<Token> input) {
        try {
            return input.next();
        }
        catch (NoSuchElementException e) {
            throw new UnfinishedExpressionException();
        }
    }

    @Override
    public N parse(IParserState<N> state, PeekingIterator<Token> input) {
        Stack nodeStack = Stack.create();
        Stack operatorStack = Stack.create();
        O defaultOperator = this.operators.getDefaultOperator();
        boolean pushedNonOperatorLastLoop = false;
        while (input.hasNext()) {
            Token token = (Token)input.peek();
            boolean pushedNonOperatorThisLoop = true;
            if (token.type.isExpressionTerminator()) break;
            InfixParser.next(input);
            if (token.type.isValue()) {
                nodeStack.push(this.nodeFactory.createValueNode(token));
            } else if (token.type.isSymbol()) {
                Preconditions.checkArgument((token.type != TokenType.SYMBOL_WITH_ARGS ? 1 : 0) != 0, (String)"Symbol '%s' can't be used in infix mode", (Object)token.value);
                if (input.hasNext()) {
                    Token nextToken = (Token)input.peek();
                    if (nextToken.type == TokenType.LEFT_BRACKET && nextToken.value.equals(CALL_OPENING_BRACKET)) {
                        input.next();
                        String openingBracket = nextToken.value;
                        String closingBracket = TokenUtils.getClosingBracket(openingBracket);
                        ISymbolCallStateTransition<N> stateTransition = state.getStateForSymbolCall(token.value);
                        List<N> childrenNodes = this.collectChildren(input, openingBracket, closingBracket, stateTransition.getState());
                        nodeStack.push(stateTransition.createRootNode(childrenNodes));
                    } else {
                        nodeStack.push(this.nodeFactory.createSymbolGetNode(token.value));
                    }
                } else {
                    nodeStack.push(this.nodeFactory.createSymbolGetNode(token.value));
                }
            } else if (token.type == TokenType.MODIFIER) {
                IModifierStateTransition<N> stateTransition = state.getStateForModifier(token.value);
                IParserState<N> newState = stateTransition.getState();
                IAstParser<N> newParser = newState.getParser();
                N parsedNode = newParser.parse(newState, input);
                nodeStack.push(stateTransition.createRootNode(parsedNode));
            } else if (token.type == TokenType.LEFT_BRACKET) {
                String openingBracket = token.value;
                String closingBracket = TokenUtils.getClosingBracket(openingBracket);
                List<N> childrenNodes = this.collectChildren(input, openingBracket, closingBracket, state);
                nodeStack.push(this.nodeFactory.createBracketNode(openingBracket, closingBracket, childrenNodes));
            } else if (token.type == TokenType.OPERATOR) {
                O op;
                if (!pushedNonOperatorLastLoop) {
                    op = this.operators.getOperator(token.value, OperatorArity.UNARY);
                    Preconditions.checkArgument((op != null ? 1 : 0) != 0, (String)"No unary version of operator: %s", (Object)token.value);
                } else {
                    op = this.operators.getOperator(token.value, OperatorArity.BINARY);
                    Preconditions.checkArgument((op != null ? 1 : 0) != 0, (String)"Invalid operator: %s", (Object)token.value);
                }
                this.pushOperator(nodeStack, operatorStack, op);
                pushedNonOperatorThisLoop = false;
            } else {
                throw new InvalidTokenException(token);
            }
            if (pushedNonOperatorLastLoop && pushedNonOperatorThisLoop) {
                Object thisLoopPush = nodeStack.pop();
                this.pushOperator(nodeStack, operatorStack, defaultOperator);
                nodeStack.push(thisLoopPush);
            }
            pushedNonOperatorLastLoop = pushedNonOperatorThisLoop;
        }
        while (!operatorStack.isEmpty()) {
            IOperator op = (IOperator)operatorStack.pop();
            this.pushOperator(nodeStack, op);
        }
        if (nodeStack.size() != 1) {
            throw new NonExpressionException("Stack: " + nodeStack.printContents());
        }
        return (N)nodeStack.pop();
    }

    private List<N> collectChildren(PeekingIterator<Token> input, String openingBracket, String closingBracket, IParserState<N> compilerState) {
        ArrayList args = Lists.newArrayList();
        if (!input.hasNext()) {
            throw new UnmatchedBracketsException(openingBracket);
        }
        if (((Token)input.peek()).type == TokenType.RIGHT_BRACKET) {
            Token token = InfixParser.next(input);
            Preconditions.checkState((boolean)token.value.equals(closingBracket), (String)"Unmatched brackets: '%s' and '%s'", (Object)openingBracket, (Object)token.value);
            return args;
        }
        while (true) {
            IAstParser<N> newParser = compilerState.getParser();
            N parsedNode = newParser.parse(compilerState, input);
            args.add(parsedNode);
            Token token = InfixParser.next(input);
            if (token.type == TokenType.RIGHT_BRACKET) {
                if (!token.value.equals(closingBracket)) {
                    throw new UnmatchedBracketsException(openingBracket, token.value);
                }
                return args;
            }
            Preconditions.checkState((token.type == TokenType.SEPARATOR ? 1 : 0) != 0, (String)"Expected arg separator, got %s", (Object)token);
        }
    }

    private void pushOperator(Stack<N> output, Stack<O> operatorStack, O newOp) {
        IOperator top;
        while (!operatorStack.isEmpty() && newOp.isLowerPriority((IOperator)(top = (IOperator)operatorStack.peek(0)))) {
            operatorStack.pop();
            this.pushOperator(output, top);
        }
        operatorStack.push(newOp);
    }

    private void pushOperator(Stack<N> nodeStack, O op) {
        ArrayList children = Lists.newArrayList();
        for (int i = 0; i < op.arity().args; ++i) {
            children.add(nodeStack.pop());
        }
        N newOpNode = this.nodeFactory.createOpNode(op, Lists.reverse((List)children));
        nodeStack.push(newOpNode);
    }
}

