/*
 * Decompiled with CFR 0.152.
 */
package io.github.zachoooo;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import io.github.zachoooo.broadcast.Broadcast;
import io.github.zachoooo.broadcast.BroadcastAnnounce;
import io.github.zachoooo.broadcast.BroadcastCommand;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;

@Plugin(id="broadcast", name="Broadcast", version="1.2.1", description="Automatically make broadcasts to your server.")
public class BroadcastPlugin {
    @Inject
    private Logger logger;
    @Inject
    @DefaultConfig(sharedRoot=true)
    private Path defaultConfig;
    @Inject
    @DefaultConfig(sharedRoot=true)
    private ConfigurationLoader<CommentedConfigurationNode> config;
    private List<Broadcast> broadcasts = new ArrayList<Broadcast>();
    private int messageIndex = 0;
    private int previousIndex = 0;
    private Task asyncBroadcastTask;
    private boolean noRepeat;

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        this.loadMessages();
    }

    @Listener
    public void reload(GameReloadEvent event) {
        this.getAsyncBroadcastTask().cancel();
        this.setMessageIndex(0);
        this.getBroadcasts().clear();
        this.loadMessages();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getConfigPath() {
        return this.defaultConfig;
    }

    public List<Broadcast> getBroadcasts() {
        return this.broadcasts;
    }

    public int getMessageIndex() {
        return this.messageIndex;
    }

    public void setMessageIndex(int messageIndex) {
        this.messageIndex = messageIndex;
    }

    public Task getAsyncBroadcastTask() {
        return this.asyncBroadcastTask;
    }

    public void setAsyncBroadcastTask(Task asyncBroadcastTask) {
        this.asyncBroadcastTask = asyncBroadcastTask;
    }

    public void setPreviousIndex(int i) {
        this.previousIndex = i;
    }

    public void loadMessages() {
        ConfigurationNode rootNode;
        this.getLogger().info("Loading messages...");
        Path potentialFile = this.getConfigPath();
        if (!Files.exists(potentialFile, new LinkOption[0])) {
            try {
                ((Asset)Sponge.getAssetManager().getAsset((Object)this, "defaultConfig.conf").get()).copyToFile(potentialFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.getLogger().error("Unable to load default config. Shutting down plugin. Report this error to plugin developer.");
                return;
            }
        }
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(potentialFile)).build();
        try {
            rootNode = loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getLogger().error("Unable to load config. Please see stack trace above. Plugin will not start.");
            return;
        }
        try {
            for (Text text : rootNode.getNode(new Object[]{"messages"}).getList(TypeToken.of(Text.class))) {
                Broadcast broadcast;
                if (text.toPlain().startsWith("/")) {
                    broadcast = new BroadcastCommand(this, text.toPlain().substring(1));
                } else {
                    text = ((Text)rootNode.getNode(new Object[]{"prefix"}).getValue(TypeToken.of(Text.class))).concat(text);
                    broadcast = new BroadcastAnnounce(this, text);
                }
                this.broadcasts.add(broadcast);
            }
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            this.getLogger().error("Configuration file was invalid and could not be loaded. Please ensure your config is proper HOCON. Plugin will not load.");
            return;
        }
        if (this.broadcasts.size() == 0) {
            this.getLogger().error("No messages listed in config file. Please add some messages!");
            return;
        }
        this.getLogger().info("Successfully loaded messages.");
        long delay = rootNode.getNode(new Object[]{"delay"}).getInt(60);
        this.noRepeat = rootNode.getNode(new Object[]{"no-repeat"}).getBoolean(true);
        this.asyncBroadcastTask = Task.builder().async().interval(delay, TimeUnit.SECONDS).name("Broadcast - Schedule Messages").execute(() -> {
            if (rootNode.getNode(new Object[]{"random"}).getBoolean(false)) {
                Random random = new Random();
                int nextIndex = random.nextInt(this.broadcasts.size());
                if (this.noRepeat && this.broadcasts.size() > 1) {
                    while (nextIndex == this.previousIndex) {
                        nextIndex = random.nextInt(this.broadcasts.size());
                    }
                }
                Broadcast randomBroadcast = this.broadcasts.get(nextIndex);
                randomBroadcast.runBroadcast();
                this.previousIndex = nextIndex;
            } else {
                Broadcast broadcast = this.broadcasts.get(this.messageIndex++);
                broadcast.runBroadcast();
                if (this.messageIndex == this.broadcasts.size()) {
                    this.messageIndex = 0;
                }
            }
        }).submit((Object)this);
    }

    public boolean isNoRepeat() {
        return this.noRepeat;
    }
}

