/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles.server;

import com.github.terminatornl.laggoggles.CommonProxy;
import com.github.terminatornl.laggoggles.Main;
import com.github.terminatornl.laggoggles.api.Profiler;
import com.github.terminatornl.laggoggles.packet.CPacketRequestScan;
import com.github.terminatornl.laggoggles.packet.SPacketMessage;
import com.github.terminatornl.laggoggles.packet.SPacketProfileStatus;
import com.github.terminatornl.laggoggles.packet.SPacketServerData;
import com.github.terminatornl.laggoggles.profiler.ProfileManager;
import com.github.terminatornl.laggoggles.profiler.ScanType;
import com.github.terminatornl.laggoggles.server.ServerConfig;
import com.github.terminatornl.laggoggles.util.Perms;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ScanRequestHandler
implements IMessageHandler<CPacketRequestScan, IMessage> {
    private static HashMap<UUID, Long> COOLDOWN = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessage onMessage(final CPacketRequestScan request, MessageContext ctx) {
        final EntityPlayerMP requestee = ctx.getServerHandler().field_147369_b;
        Perms.Permission requesteePerms = Perms.getPermission((EntityPlayer)requestee);
        if (requesteePerms.ordinal() < Perms.Permission.START.ordinal()) {
            Main.LOGGER.info(requestee.func_70005_c_() + " Tried to start the profiler, but was denied to do so!");
            return new SPacketMessage("No permission");
        }
        if (requesteePerms != Perms.Permission.FULL && request.length > ServerConfig.NON_OPS_MAX_PROFILE_TIME) {
            return new SPacketMessage("Profile time is too long! You can profile up to " + ServerConfig.NON_OPS_MAX_PROFILE_TIME + " seconds.");
        }
        Object object = ProfileManager.LOCK;
        synchronized (object) {
            if (ProfileManager.PROFILER_ENABLED_UPDATE_SAFE) {
                return new SPacketMessage("Profiler is already running");
            }
        }
        long secondsLeft = ScanRequestHandler.secondsLeft(requestee.func_146103_bH().getId());
        if (secondsLeft > 0L && requesteePerms != Perms.Permission.FULL) {
            return new SPacketMessage("Please wait " + secondsLeft + " seconds.");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Profiler.runProfiler(request.length, ScanType.WORLD, (ICommandSender)requestee);
                SPacketProfileStatus status2 = new SPacketProfileStatus(false, request.length, requestee.func_70005_c_());
                for (EntityPlayerMP user : Perms.getLagGogglesUsers()) {
                    CommonProxy.sendTo(status2, user);
                }
                CommonProxy.sendTo(ProfileManager.LAST_PROFILE_RESULT.get(), requestee);
                for (EntityPlayerMP user : Perms.getLagGogglesUsers()) {
                    CommonProxy.sendTo(new SPacketServerData(user), user);
                }
            }
        }).start();
        return null;
    }

    public static long secondsLeft(UUID uuid) {
        long lastRequest = COOLDOWN.getOrDefault(uuid, 0L);
        long secondsLeft = (long)ServerConfig.NON_OPS_PROFILE_COOL_DOWN_SECONDS - (System.currentTimeMillis() - lastRequest) / 1000L;
        if (secondsLeft <= 0L) {
            COOLDOWN.put(uuid, System.currentTimeMillis());
        }
        return secondsLeft;
    }
}

