/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.util.info;

import ic2.api.classic.tile.IInfoTile;
import ic2.core.block.base.util.info.misc.IHeatProvider;
import ic2.core.block.base.util.info.misc.IProbeComponent;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

public class HeatInfo
implements IProbeComponent {
    IHeatProvider heat;

    public HeatInfo(IHeatProvider tile) {
        this.heat = tile;
    }

    @Override
    public String getDisplayText(EntityPlayer player) {
        return Ic2InfoLang.reactorHeat.getLocalizedFormatted(this.heat.getHeat(), this.heat.getMaxHeat());
    }

    @Override
    public boolean canShow(EntityPlayer player) {
        return PlayerHandler.getClientPlayerHandler().hasThermometer();
    }

    @Override
    public IInfoTile.InfoType getType() {
        return IInfoTile.InfoType.Custom;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public boolean isModeValid(ProbeMode mode, PlayerHandler handler) {
        return mode != ProbeMode.NORMAL && handler.hasThermometer();
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void applyInfo(IProbeInfo info, EntityPlayer player, EnumFacing side) {
        info.progress(this.heat.getHeat(), this.heat.getMaxHeat(), info.defaultProgressStyle().prefix("Heat: "));
    }
}

