/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.bossbar;

import java.util.Set;
import net.kyori.adventure.bossbar.BossBarImpl;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.util.Index;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface BossBar {
    public static final float MIN_PERCENT = 0.0f;
    public static final float MAX_PERCENT = 1.0f;

    public static @NonNull BossBar bossBar(@NonNull Component name, float percent, @NonNull Color color, @NonNull Overlay overlay) {
        BossBarImpl.checkPercent(percent);
        return new BossBarImpl(name, percent, color, overlay);
    }

    public static @NonNull BossBar bossBar(@NonNull Component name, float percent, @NonNull Color color, @NonNull Overlay overlay, @NonNull Set<Flag> flags) {
        BossBarImpl.checkPercent(percent);
        return new BossBarImpl(name, percent, color, overlay, flags);
    }

    public @NonNull Component name();

    public @NonNull BossBar name(@NonNull Component var1);

    public float percent();

    public @NonNull BossBar percent(float var1);

    public @NonNull Color color();

    public @NonNull BossBar color(@NonNull Color var1);

    public @NonNull Overlay overlay();

    public @NonNull BossBar overlay(@NonNull Overlay var1);

    public @NonNull Set<Flag> flags();

    public @NonNull BossBar flags(@NonNull Set<Flag> var1);

    public boolean hasFlag(@NonNull Flag var1);

    public @NonNull BossBar addFlag(@NonNull Flag var1);

    public @NonNull BossBar removeFlag(@NonNull Flag var1);

    public @NonNull BossBar addFlags(Flag ... var1);

    public @NonNull BossBar removeFlags(Flag ... var1);

    public @NonNull BossBar addFlags(@NonNull Iterable<Flag> var1);

    public @NonNull BossBar removeFlags(@NonNull Iterable<Flag> var1);

    public @NonNull BossBar addListener(@NonNull Listener var1);

    public @NonNull BossBar removeListener(@NonNull Listener var1);

    public static enum Overlay {
        PROGRESS("progress"),
        NOTCHED_6("notched_6"),
        NOTCHED_10("notched_10"),
        NOTCHED_12("notched_12"),
        NOTCHED_20("notched_20");

        public static final Index<String, Overlay> NAMES;
        private final String name;

        private Overlay(String name) {
            this.name = name;
        }

        static {
            NAMES = Index.create(Overlay.class, overlay -> overlay.name);
        }
    }

    public static enum Flag {
        DARKEN_SCREEN("darken_screen"),
        PLAY_BOSS_MUSIC("play_boss_music"),
        CREATE_WORLD_FOG("create_world_fog");

        public static final Index<String, Flag> NAMES;
        private final String name;

        private Flag(String name) {
            this.name = name;
        }

        static {
            NAMES = Index.create(Flag.class, flag -> flag.name);
        }
    }

    public static enum Color {
        PINK("pink"),
        BLUE("blue"),
        RED("red"),
        GREEN("green"),
        YELLOW("yellow"),
        PURPLE("purple"),
        WHITE("white");

        public static final Index<String, Color> NAMES;
        private final String name;

        private Color(String name) {
            this.name = name;
        }

        static {
            NAMES = Index.create(Color.class, color -> color.name);
        }
    }

    public static interface Listener {
        default public void bossBarNameChanged(@NonNull BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
        }

        default public void bossBarPercentChanged(@NonNull BossBar bar, float oldPercent, float newPercent) {
        }

        default public void bossBarColorChanged(@NonNull BossBar bar, @NonNull Color oldColor, @NonNull Color newColor) {
        }

        default public void bossBarOverlayChanged(@NonNull BossBar bar, @NonNull Overlay oldOverlay, @NonNull Overlay newOverlay) {
        }

        default public void bossBarFlagsChanged(@NonNull BossBar bar, @NonNull Set<Flag> flagsAdded, @NonNull Set<Flag> flagsRemoved) {
        }
    }
}

