/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.legacy;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializerImpl;
import net.kyori.adventure.text.serializer.legacy.LegacyFormat;
import net.kyori.adventure.util.Buildable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface LegacyComponentSerializer
extends ComponentSerializer<Component, TextComponent, String>,
Buildable<LegacyComponentSerializer, Builder> {
    public static final char SECTION_CHAR = '\u00a7';
    public static final char AMPERSAND_CHAR = '&';
    public static final char HEX_CHAR = '#';

    public static @NonNull LegacyComponentSerializer legacySection() {
        return LegacyComponentSerializerImpl.SECTION_SERIALIZER;
    }

    public static @NonNull LegacyComponentSerializer legacyAmpersand() {
        return LegacyComponentSerializerImpl.AMPERSAND_SERIALIZER;
    }

    public static @NonNull LegacyComponentSerializer legacy(char legacyCharacter) {
        if (legacyCharacter == '\u00a7') {
            return LegacyComponentSerializer.legacySection();
        }
        if (legacyCharacter == '&') {
            return LegacyComponentSerializer.legacyAmpersand();
        }
        return LegacyComponentSerializer.builder().character(legacyCharacter).build();
    }

    public static @Nullable LegacyFormat parseChar(char character) {
        return LegacyComponentSerializerImpl.legacyFormat(character);
    }

    public static @NonNull Builder builder() {
        return new LegacyComponentSerializerImpl.BuilderImpl();
    }

    @Override
    public @NonNull TextComponent deserialize(@NonNull String var1);

    @Override
    public @NonNull String serialize(@NonNull Component var1);

    public static interface Builder
    extends Buildable.Builder<LegacyComponentSerializer> {
        public @NonNull Builder character(char var1);

        public @NonNull Builder hexCharacter(char var1);

        public @NonNull Builder extractUrls();

        public @NonNull Builder extractUrls(@Nullable Style var1);

        public @NonNull Builder hexColors();

        public @NonNull Builder useUnusualXRepeatedCharacterHexFormat();

        @Override
        public @NonNull LegacyComponentSerializer build();
    }
}

